% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.s2dv_cube.R
\name{as.s2dv_cube}
\alias{as.s2dv_cube}
\title{Conversion of 'startR_array' or 'list' objects to 's2dv_cube'}
\usage{
as.s2dv_cube(object, remove_attrs_coords = FALSE, remove_null = FALSE)
}
\arguments{
\item{object}{An object of class 'startR_array' generated from function 
\code{Start} from startR package or a list output from function \code{Load} 
from s2dv package. Any other object class will not be accepted.}

\item{remove_attrs_coords}{A logical value indicating whether to remove the 
attributes of the coordinates (TRUE) or not (FALSE). The default value is 
FALSE.}

\item{remove_null}{Optional. A logical value indicating whether to remove the
elements that are NULL (TRUE) or not (FALSE) of the output object. It is 
only used when the object is an output from function \code{Load}. The 
default value is FALSE.}
}
\value{
The function returns an 's2dv_cube' object to be easily used with 
functions with the prefix \code{CST} from CSTools and CSIndicators packages. 
The object is mainly a list with the following elements:\cr
\itemize{
 \item{'data', array with named dimensions.}
 \item{'dims', named vector of the data dimensions.}
 \item{'coords', named list with elements of the coordinates corresponding to
 the dimensions of the data parameter. If any coordinate is not provided, it 
 is set as an index vector with the values from 1 to the length of the 
 corresponding dimension. The attribute 'indices' indicates wether the 
 coordinate is an index vector (TRUE) or not (FALSE).}
 \item{'attrs', named list with elements:
   \itemize{
     \item{'Dates', array with named temporal dimensions of class 'POSIXct' 
           from time values in the data.}
     \item{'Variable', has the following components:
       \itemize{
         \item{'varName', character vector of the short variable name. It is  
               usually specified in the parameter 'var' from the functions 
               Start and Load.}
         \item{'metadata', named list of elements with variable metadata. 
               They can be from coordinates variables (e.g. longitude) or 
               main variables (e.g. 'var').}
       }
     }
     \item{'Datasets', character strings indicating the names of the 
           datasets.}
     \item{'source_files', a vector of character strings with complete paths 
           to all the found files involved in loading the data.}
     \item{'when', a time stamp of the date issued by the Start() or Load() 
           call to obtain the data.}
     \item{'load_parameters', it contains the components used in the 
           arguments to load the data from Start() or Load() functions.}
   }
 }
}
}
\description{
This function converts data loaded using Start function from startR package or 
Load from s2dv into an 's2dv_cube' object.
}
\examples{
\dontrun{
# Example 1: convert an object from startR::Start function to 's2dv_cube'
library(startR)
repos <- '/esarchive/exp/ecmwf/system5_m1/monthly_mean/$var$_f6h/$var$_$sdate$.nc'
data <- Start(dat = repos,
             var = 'tas',
             sdate = c('20170101', '20180101'),
             ensemble = indices(1:5),
             time = 'all',
             latitude = indices(1:5),
             longitude = indices(1:5),
             return_vars = list(latitude = 'dat', longitude = 'dat', time = 'sdate'),
             retrieve = TRUE)
data <- as.s2dv_cube(data)
# Example 2: convert an object from s2dv::Load function to 's2dv_cube'
startDates <- c('20001101', '20011101', '20021101',
               '20031101', '20041101', '20051101')
data <- Load(var = 'tas', exp = 'system5c3s', 
            nmember = 2, sdates = startDates,
            leadtimemax = 3, latmin = 10, latmax = 30,
            lonmin = -10, lonmax = 10, output = 'lonlat')
data <- as.s2dv_cube(data)
}
}
\seealso{
\code{\link{s2dv_cube}}, \code{\link[s2dv]{Load}}, 
\code{\link[startR]{Start}} and \code{\link{CST_Load}}
}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}

Nicolau Manubens, \email{nicolau.manubens@bsc.es}
}
