% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_data.R
\docType{data}
\name{areave_data}
\alias{areave_data}
\title{Sample Of Experimental And Observational Climate Data Averaged Over A Region}
\description{
This sample data set contains area-averaged seasonal forecast and corresponding observational data from the Copernicus Climate Change ECMWF-System 5 forecast system, and from the Copernicus Climate Change ERA-5 reconstruction. Specifically, for the 'tas' (2-meter temperature) variable, for the 15 first forecast ensemble members, monthly averaged, for the 3 first forecast time steps (lead months 1 to 4) of the November start dates of 2000 to 2005, for the Mediterranean region (27N-48N, 12W-40E).
}
\details{
It is recommended to use the data set as follows:
\preformatted{
require(zeallot)
c(exp, obs) %<-% CSTools::areave_data
}

The `CST_Load` call used to generate the data set in the infrastructure of the Earth Sciences Department of the Barcelona Supercomputing Center is shown next. Note that `CST_Load` internally calls `s2dverification::Load`, which would require a configuration file (not provided here) expressing the distribution of the 'system5c3s' and 'era5' NetCDF files in the file system.
\preformatted{
library(CSTools)
require(zeallot)

startDates <- c('20001101', '20011101', '20021101',
                '20031101', '20041101', '20051101')

areave_data <-  
  CST_Load(
    var = 'tas', 
    exp = 'system5c3s', 
    obs = 'era5', 
    nmember = 15,
    sdates = startDates,
    leadtimemax = 3,
    latmin = 27, latmax = 48,
    lonmin = -12, lonmax = 40, 
    output = 'areave',
    nprocs = 1
  )
}
}
\author{
Nicolau Manubens \email{nicolau.manubens@bsc.es}
}
\keyword{data}
