% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_cste_surv.R
\name{predict_cste_surv}
\alias{predict_cste_surv}
\title{Predict the CSTE curve of new data for time to event outcome with right censoring.}
\usage{
predict_cste_surv(obj, newx, alpha = 0.05)
}
\arguments{
\item{obj}{a S3 class of cste.}

\item{newx}{samples of covariates which is a \eqn{m*p} matrix.}

\item{alpha}{(1-\eqn{\alpha}) confidence level.}
}
\value{
A S3 class of cste, which includes
\itemize{
   \item \code{g1}: predicted \eqn{g_1(X\beta_1)}.
   \item \code{lower_bound}: the lower bound of CSTE's pointwise confidence intervals.
   \item \code{upper_bound}: the upper bound of CSTE's pointwise confidence intervals.
}
}
\description{
Predict the CSTE curve of new data for time to event outcome with right censoring.
}
\references{
Ma Y. and Zhou X. (2017). 
Treatment selection in a randomized clinical trial via covariate-specific 
treatment effect curves, \emph{Statistical Methods in Medical Research}, 26(1), 124-141.
}
\seealso{
\code{\link{cste_surv}}
}
