% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_cste_bin.R
\name{predict_cste_bin}
\alias{predict_cste_bin}
\title{Predict the CSTE curve of new data for binary outcome.}
\usage{
predict_cste_bin(obj, newx)
}
\arguments{
\item{obj}{a S3 class of cste.}

\item{newx}{samples of covariates which is a \eqn{m*p} matrix.}
}
\value{
A S3 class of cste which includes 
\itemize{
   \item \code{g1}: predicted \eqn{g_1(X\beta_1)}. 
   \item \code{g2}: predicted \eqn{g_2(X\beta_2)}.
   \item \code{B1}: the B-spline basis for estimating \eqn{g_1}.
   \item \code{B2}: the B-spline basis for estimating \eqn{g_2}. 
}
}
\description{
Predict the CSTE curve of new data for binary outcome.
}
\references{
Guo W., Zhou X. and Ma S. (2021).
Estimation of Optimal Individualized Treatment Rules
Using a Covariate-Specific Treatment Effect Curve with 
High-dimensional Covariates,
\emph{Journal of the American Statistical Association}, 116(533), 309-321
}
\seealso{
\code{\link{cste_bin}}
}
