% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_qa_hydrograph.R
\name{ch_qa_hydrograph}
\alias{ch_qa_hydrograph}
\title{Plots a hydrograph with the data quality symbols and returns a report on qa symbols and missing data.}
\usage{
ch_qa_hydrograph(
  DF,
  st_date = NULL,
  end_date = NULL,
  cts = TRUE,
  rescale = FALSE,
  sym_col = c("black", "green", "cyan", "yellow", "red", "white"),
  metadata = NULL
)
}
\arguments{
\item{DF}{Data frame retrieved from ECDataExplorer as returned by the function 
\code{ch_read_ECDE_flows}.}

\item{st_date}{Optional start date in the form \option{yyyy-mm-dd}. Default is \code{NULL}.}

\item{end_date}{Optional end date in the form \option{yyyy-mm-dd}. Default is \code{NULL}.}

\item{cts}{If \code{TRUE} (the default) shows the counts of SYM in the legend. If \code{FALSE} 
the counts are omitted as in ECDE.}

\item{rescale}{If \code{FALSE} (the default), the y-axis scaling is determined by the time 
period. If \code{TRUE} then determined by the whole dataset.}

\item{sym_col}{Colours used for SYM; default is those used in ECDE ("black",
"green", "cyan","yellow", "red", "white").  The final "white" can be changed to highlight
missing data points.}

\item{metadata}{a dataframe of station metadata, default is \code{HYDAT_list}.}
}
\value{
Produces a plot and returns a list that contains:
\item{station name or title used}{}
\item{st_date}{starting date}
\item{end_date}{ending data}
\item{n}{the number of data points}
\item{sym_count}{summary of the SYM counts}
\item{missing}{number of missing data}
}
\description{
Plots a hydrograph of a WSC daily data file read from from ECDataExplorer (ECDE). 
The hydrograph shows individual days with data quality symbols [SYM] 
in colour and counts cases of each and reports them in the legend. The colours and symbols 
are those produced by ECDataExplorer. 

There is an option is to provide start and end dates to show 
only part of the time period for which data exists and the plot is annotated to indicate this. 
Counts of missing observations is also provided in the legend.
}
\examples{
m_test <- ch_qa_hydrograph(CAN05AA008)
m_test <- ch_qa_hydrograph(CAN05AA008, st_date="1980-01-01", end_date="1999-12-31")
}
\author{
Paul Whitfield
}
