% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMMA_data.R
\name{COMMA_data}
\alias{COMMA_data}
\title{Generate Data to use in COMMA Functions}
\usage{
COMMA_data(
  sample_size,
  x_mu,
  x_sigma,
  z_shape,
  c_shape,
  interaction_indicator,
  outcome_distribution,
  true_beta,
  true_gamma,
  true_theta
)
}
\arguments{
\item{sample_size}{An integer specifying the sample size of the generated data set.}

\item{x_mu}{A numeric value specifying the mean of \code{x} predictors
generated from a Normal distribution.}

\item{x_sigma}{A positive numeric value specifying the standard deviation of
\code{x} predictors generated from a Normal distribution.}

\item{z_shape}{A positive numeric value specifying the shape parameter of
\code{z} predictors generated from a Gamma distribution.}

\item{c_shape}{A positive numeric value specifying the shape parameter of
\code{c} covariates generated from a Gamma distribution.}

\item{interaction_indicator}{A logical value indicating if an interaction between
\code{x} and \code{m} should be used to generate the outcome variable, \code{y}.}

\item{outcome_distribution}{A character string specifying the distribution of
the outcome variable. Options are \code{"Bernoulli"}, \code{"Normal"}, or
\code{"Poisson"}.}

\item{true_beta}{A column matrix of \eqn{\beta} parameter values (intercept, slope)
to generate data under in the true mediator mechanism.}

\item{true_gamma}{A numeric matrix of \eqn{\gamma} parameters
to generate data in the observed mediator mechanisms.
In matrix form, the \code{gamma} matrix rows correspond to intercept (row 1)
and slope (row 2) terms. The gamma parameter matrix columns correspond to the true mediator categories
\eqn{M \in \{1, 2\}}.}

\item{true_theta}{A column matrix of \eqn{\theta} parameter values (intercept, slope
coefficient for \code{x}, slope coefficient for \code{m}, slope coefficient for \code{c},
and, optionally, slope coefficient for \code{xm} if using) to generate data
in the outcome mechanism.}
}
\value{
\code{COMMA_data} returns a list of generated data elements:
\item{obs_mediator}{A vector of observed mediator values.}
\item{true_mediator}{A vector of true mediator values.}
\item{outcome}{A vector of outcome values.}
\item{x}{A vector of generated predictor values in the true mediator
mechanism, from the Normal distribution.}
\item{z}{A vector of generated predictor values in the observed mediator
mechanism from the Gamma distribution.}
\item{c}{A vector of generated covariates.}
\item{x_design_matrix}{The design matrix for the \code{x} predictor.}
\item{z_design_matrix}{The design matrix for the \code{z} predictor.}
\item{c_design_matrix}{The design matrix for the \code{c} predictor.}
}
\description{
Generate Data to use in COMMA Functions
}
\examples{
set.seed(20240709)
sample_size <- 10000

n_cat <- 2 # Number of categories in the binary mediator

# Data generation settings
x_mu <- 0
x_sigma <- 1
z_shape <- 1
c_shape <- 1

# True parameter values (gamma terms set the misclassification rate)
true_beta <- matrix(c(1, -2, .5), ncol = 1)
true_gamma <- matrix(c(1, 1, -.5, -1.5), nrow = 2, byrow = FALSE)
true_theta <- matrix(c(1, 1.5, -2, -.2), ncol = 1)

example_data <- COMMA_data(sample_size, x_mu, x_sigma, z_shape, c_shape,
                           interaction_indicator = FALSE,
                           outcome_distribution = "Bernoulli",
                           true_beta, true_gamma, true_theta)

head(example_data$obs_mediator)
head(example_data$true_mediator) 

}
