% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{SA_estimate}
\alias{SA_estimate}
\title{Estimate sensitivity indices}
\usage{
SA_estimate(yy, N, d, Nboot = NULL)
}
\arguments{
\item{yy}{A vector of model output values, as a result of a \eqn{N(d+2)} Monte Carlo design.}

\item{N}{The number of sample points per dimension.}

\item{d}{The dimensionality of the sample}

\item{Nboot}{Number of bootstrap draws for estimates of confidence intervals on sensitivity indices.
If this is not specified, bootstrapping is not applied.}
}
\value{
A list with the output variance, plus a data frame of first order and total order sensitivity indices for
each variable, as well as bootstrapped confidence intervals if \code{!is.null(Nboot)}.
}
\description{
Post process a sample to obtain sensitivity indices. This function takes a univariate output
which is generated as a result of running a Monte Carlo sample from \code{\link[=SA_sample]{SA_sample()}} through a system.
Then it estimates sensitivity indices using this sample.
}
\details{
This function is built to be used inside \code{\link[=get_sensitivity]{get_sensitivity()}}.
}
\examples{
# This is a generic example rather than applied to a COIN (for reasons of speed)

# A simple test function
testfunc <- function(x){
x[1] + 2*x[2] + 3*x[3]
}

# First, generate a sample
X <- SA_sample(500, 3)

# Run sample through test function to get corresponding output for each row
y <- apply(X, 1, testfunc)

# Estimate sensitivity indices using sample
SAinds <- SA_estimate(y, N = 500, d = 3, Nboot = 1000)
SAinds$SensInd
# Notice that total order indices have narrower confidence intervals than first order.

}
\seealso{
\itemize{
\item \code{\link[=get_sensitivity]{get_sensitivity()}} Perform global sensitivity or uncertainty analysis on a COIN
\item \code{\link[=SA_sample]{SA_sample()}} Input design for estimating sensitivity indices
}
}
