% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_cables_60_30kv.R
\name{environmental_cof_cables_60_30kv}
\alias{environmental_cof_cables_60_30kv}
\title{Environmental cost of Failure for 30-60 kV UG cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
environmental_cof_cables_60_30kv(ehv_asset_category, prox_water, bunded)
}
\arguments{
\item{ehv_asset_category}{Asset category for the analysis}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m
(cf. table 231, page 188, CNAIM, 2021).}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#' @return Numeric. Financial consequences of failure for LV switchgear
\code{ehv_asset_category = c("30kV UG Cable (Gas)", "60kV UG Cable (Gas)",
"30kV UG Cable (Non Pressurised)", "60kV UG Cable (Non Pressurised)",
"30kV UG Cable (Oil)", "60kV UG Cable (Oil)")
}. The default setting is
\code{ehv_asset_category = "60kV UG Cable (Gas)"}.
}
\examples{
environmental_cof_cables_60_30kv(ehv_asset_category = "30kV UG Cable (Oil)",
prox_water = 95, bunded = "Yes")
}
