% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3generics_clvfittedspending_plot.R
\name{plot.clv.fitted.spending}
\alias{plot.clv.fitted.spending}
\alias{plot,clv.fitted.spending-method}
\title{Plot expected and actual mean spending per transaction}
\usage{
\method{plot}{clv.fitted.spending}(x, n = 256, verbose = TRUE, ...)

\S4method{plot}{clv.fitted.spending}(x, n = 256, verbose = TRUE, ...)
}
\arguments{
\item{x}{The fitted spending model to plot}

\item{n}{Number of points at which the empirical and model density are calculated. Should be a power of two.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Ignored}
}
\value{
An object of class \code{ggplot} from package \code{ggplot2} is returned by default.
}
\description{
Compares the density of the observed average spending per transaction (empirical distribution) to the
model's distribution of mean transaction spending (weighted by the actual number of transactions).
}
\examples{
\donttest{
data("cdnow")

clv.cdnow <- clvdata(cdnow,
  date.format="ymd",
  time.unit = "week",
  estimation.split = "1997-09-30")

est.gg <- gg(clv.data = clv.cdnow)

# Compare empirical to theoretical distribution
plot(est.gg)

\dontrun{
# Modify the created plot further
library(ggplot2)
gg.cdnow <- plot(est.gg)
gg.cdnow + ggtitle("CDnow Spending Distribution")
}
}

}
\references{
Colombo R, Jiang W (1999). \dQuote{A stochastic RFM model.}
Journal of Interactive Marketing, 13(3), 2–12.

Fader PS, Hardie BG, Lee K (2005). \dQuote{RFM and CLV: Using Iso-Value Curves for
Customer Base Analysis.} Journal of Marketing Research, 42(4), 415–430.

Fader PS, Hardie BG (2013). \dQuote{The Gamma-Gamma Model of Monetary Value.}
URL \url{http://www.brucehardie.com/notes/025/gamma_gamma.pdf}.
}
\seealso{
\code{\link[CLVTools:plot.clv.fitted.transactions]{plot}} for transaction models
}
