% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_interface_ggomnbd.R
\name{ggomnbd}
\alias{ggomnbd}
\alias{ggomnbd,clv.data-method}
\alias{ggomnbd,clv.data.static.covariates-method}
\alias{ggomnbd,clv.data.dynamic.covariates-method}
\title{Gamma-Gompertz/NBD models - Work In Progress}
\usage{
\S4method{ggomnbd}{clv.data}(
  clv.data,
  start.params.model = c(),
  optimx.args = list(),
  verbose = TRUE,
  ...
)

\S4method{ggomnbd}{clv.data.static.covariates}(
  clv.data,
  start.params.model = c(),
  optimx.args = list(),
  verbose = TRUE,
  names.cov.life = c(),
  names.cov.trans = c(),
  start.params.life = c(),
  start.params.trans = c(),
  names.cov.constr = c(),
  start.params.constr = c(),
  reg.lambdas = c(),
  ...
)

\S4method{ggomnbd}{clv.data.dynamic.covariates}(
  clv.data,
  start.params.model = c(),
  optimx.args = list(),
  verbose = TRUE,
  names.cov.life = c(),
  names.cov.trans = c(),
  start.params.life = c(),
  start.params.trans = c(),
  names.cov.constr = c(),
  start.params.constr = c(),
  reg.lambdas = c(),
  ...
)
}
\arguments{
\item{clv.data}{The data object on which the model is fitted.}

\item{start.params.model}{Named start parameters containing the optimization start parameters for the model without covariates.}

\item{optimx.args}{Additional arguments to control the optimization which are forwarded to \code{\link[optimx:optimx]{optimx::optimx}}.
If multiple optimization methods are specified, only the result of the last method is further processed.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Ignored}

\item{names.cov.life}{Which of the set Lifetime covariates should be used. Missing parameter indicates all covariates shall be used.}

\item{names.cov.trans}{Which of the set Transaction covariates should be used. Missing parameter indicates all covariates shall be used.}

\item{start.params.life}{Named start parameters containing the optimization start parameters for all lifetime covariates.}

\item{start.params.trans}{Named start parameters containing the optimization start parameters for all transaction covariates.}

\item{names.cov.constr}{Which covariates should be forced to use the same parameters for the lifetime and transaction process. The covariates need to be present as both, lifetime and transaction covariates.}

\item{start.params.constr}{Named start parameters containing the optimization start parameters for the constraint covariates.}

\item{reg.lambdas}{Named lambda parameters used for the L2 regularization of the lifetime and the transaction covariate parameters. Lambdas have to be >= 0.}
}
\value{
No value is returned.
}
\description{
Fits Gamma-Gompertz/NBD models on transactional data with static and without covariates. Not yet implemented.
}
