% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{residuals.clme}
\alias{residuals.clme}
\alias{residuals.summary.clme}
\title{Various types of residuals}
\usage{
\method{residuals}{clme}(object, type = "FM", ...)

\method{residuals}{summary.clme}(object, type = "FM", ...)
}
\arguments{
\item{object}{object of class \code{\link{clme}}.}

\item{type}{type of residual (for mixed-effects models only).}

\item{...}{space for additional arguments}
}
\value{
Returns a numeric matrix.
}
\description{
Computes several types of residuals for objects of class \code{clme}.
}
\details{
For fixed-effects models \eqn{Y = X\beta + \epsilon}{Y = X*b + e}, residuals are given as \deqn{\hat{e} = Y - X\hat{\beta}}{ ehat = Y - X*betahat}.
For mixed-effects models \eqn{Y = X\beta + + U\xi + \epsilon}{Y = X*b + U*xi + e}, three types of residuals are available.
\eqn{PA = Y - X\hat{\beta}}{ PA = Y - X*betahat}\\
\eqn{SS = U\hat{\xi}}{ SS = U*xihat}\\
\eqn{FM = Y - X\hat{\beta} - U\hat{\xi}}{ FM = Y - X*betahat - U*xihat}
}
\examples{
\dontrun{
data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                 constraints = cons, seed = 42, nsim = 0)
                 
residuals( clme.out, type='PA' )
}
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}
