% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relationship_zone_perimeters.R
\name{relationship_zone_perimeters}
\alias{relationship_zone_perimeters}
\title{Return the perimeters of all the relationship zones}
\usage{
relationship_zone_perimeters()
}
\value{
Returns a tibble with the following columns:
\itemize{
\item \code{which_matrix}: a column of values \code{M1} or \code{M2}.  M1 denotes that the row's values
are for the relationship zone found in or below the lower diagonal of the ancestry match matrix
and M2 denotes that the row's value are of the zone found in the upper part of the
ancestry match matrix.  Symmetrical relationships are considered to be M1.
\item \code{zone}: The abbreviation for the relationship (e.g., Se, PO, Si, etc.)
\item \code{xmin}: The left-hand x value of the zone.
\item \code{xmax}: The right-hand x value of the zone.
\item \code{ymin}: The bottom y value of the zone.
\item \code{ymax}: The top y value of the zone.
\item \code{area}: The area in unit squares of the zone.
\item \code{xmid}: The x midpoint of the zone.
\item \code{ymid}: The y midpoint of the zone.
}
}
\description{
This is primarily for plotting a figure in the paper about this package,
showing where all the relationship zones are.  It merely cycles over the
possible relationships in \code{\link{relationship_zone_names}} and produces one or
two rows in a tibble for each that has the corners of the rectangle of that
zone in the columns xmin, xmax, ymin, and ymax.  It is designed to be overlaid
upon the ancestry_match_matrix plots. There are some additional columns that give
us the midpoint of the area, etc.
}
\examples{
relationship_zone_perimeters()
}
