% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_S3_methods.R, R/CGGP_pred_fs.R
\name{predict.CGGP}
\alias{predict.CGGP}
\alias{CGGPpred}
\title{S3 predict method for CGGP}
\usage{
\method{predict}{CGGP}(object, xp, ...)

CGGPpred(CGGP, xp, theta = NULL, outdims = NULL)
}
\arguments{
\item{object}{CGGP object}

\item{xp}{x value to predict at}

\item{...}{Other arguments passed to `CGGPpred`}

\item{CGGP}{SG object}

\item{theta}{Leave as NULL unless you want to use a value other than thetaMAP.
Much slower.}

\item{outdims}{If multiple outputs fit without PCA and with separate
parameters, you can predict just for certain dimensions to speed it up.
Will leave other columns in the output, but they will be wrong.}
}
\value{
Predicted mean values
}
\description{
Passes to CGGPpred

Predict using SG with y values at xp?
Shouldn't y values already be stored in SG?
}
\examples{
SG <- CGGPcreate(d=3, batchsize=100)
y <- apply(SG$design, 1, function(x){x[1]+x[2]^2+rnorm(1,0,.01)})
SG <- CGGPfit(SG, Y=y)
CGGPpred(SG, matrix(c(.1,.1,.1),1,3))
cbind(CGGPpred(SG, SG$design)$mean, y) # Should be near equal
}
\seealso{
Other CGGP core functions: \code{\link{CGGPappend}},
  \code{\link{CGGPcreate}}, \code{\link{CGGPfit}}
}
\concept{CGGP core functions}
