% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure_map.R
\name{exposure_map}
\alias{exposure_map}
\title{Create an exposure map}
\usage{
exposure_map(dep, parallel = FALSE, n, filename = "", ...)
}
\arguments{
\item{dep}{Object of class \code{departure}}

\item{parallel}{logical. If \code{TRUE} then multiple cores are utilized}

\item{n}{numeric. Number of cores to use for calculation (optional)}

\item{filename}{character. Output filename (optional)}

\item{...}{Additional arguments for file writing as for \code{\link[raster]{writeRaster}}}
}
\value{
A RasterLayer of exposure values
}
\description{
Creates a map of exposure to climate change in a species' habitat from a
\code{departure} object.
}
\details{
The values of the exposure raster are calculated by projecting onto the
departure factor \strong{d}, given by the formula

  \eqn{\epsilon} = \bold{Fd}.
}
\examples{
dep <- departure(x = climdat.hist, y = climdat.fut, s.dat = ABPR)
exp.map <- exposure_map(dep)

}
\seealso{
\code{\link{departure}}, \code{\link{sensitivity_map}}, \code{\link{vulnerability_map}}
}
