% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enfa.R
\name{enfa}
\alias{enfa}
\alias{print.enfa}
\alias{show.enfa}
\alias{enfa,GLcenfa,Raster-method}
\alias{enfa,GLcenfa,Spatial-method}
\alias{enfa,Raster,Raster-method}
\alias{enfa,Raster,Spatial-method}
\title{Ecological-niche factor analysis}
\usage{
enfa(x, s.dat, ...)

\S4method{enfa}{GLcenfa,Raster}(
  x,
  s.dat,
  filename = "",
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE,
  ...
)

\S4method{enfa}{GLcenfa,Spatial}(
  x,
  s.dat,
  field,
  fun = "last",
  filename = "",
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE,
  ...
)

\S4method{enfa}{Raster,Raster}(
  x,
  s.dat,
  scale = TRUE,
  filename = "",
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE,
  ...
)

\S4method{enfa}{Raster,Spatial}(
  x,
  s.dat,
  field,
  fun = "last",
  scale = TRUE,
  filename = "",
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE,
  ...
)
}
\arguments{
\item{x}{Raster* object, typically a brick or stack of ecological raster layers,
or a \code{GLcenfa} object}

\item{s.dat}{RasterLayer, SpatialPolygons*, or SpatialPoints* object indicating
species presence or abundance}

\item{...}{Additional arguments for \code{\link[raster]{writeRaster}}}

\item{filename}{character. Optional filename to save the Raster* output to
file. If this is not provided, a temporary file will be created for large \code{x}}

\item{progress}{logical. If \code{TRUE}, messages and progress bar will be
printed}

\item{parallel}{logical. If \code{TRUE} then multiple cores are utilized for the
calculation of the covariance matrices}

\item{n}{numeric. Number of CPU cores to utilize for parallel processing}

\item{cl}{optional cluster object}

\item{keep.open}{logical. If \code{TRUE} and \code{parallel = TRUE}, the
cluster object will not be closed after the function has finished}

\item{field}{field of \code{s.dat} that specifies presence or abundance. This
is equivalent to the \code{field} argument in the \code{raster} package}

\item{fun}{function or character. Determines what values to assign to cells
with multiple spatial features, similar to the \code{fun} argument in
\code{\link[raster]{rasterize}}.  Options are 'first', 'last' (default),
and 'count' (see Details)}

\item{scale}{logical. If \code{TRUE} then the values of the Raster* object will
be centered and scaled. Depending on the resolution of the climate data and
the extent of the study area, this can be quite time consuming. If running
this function for multiple species, it is recommended that the climate data
be scaled beforehand using the \code{\link{GLcenfa}} function}
}
\value{
Returns an S4 object of class \code{enfa} with the following components:
\describe{
  \item{call}{Original function call}
  \item{mf}{Marginality factor. Vector that describes the location of the
   species Hutchinsonian niche relative to the global niche}
  \item{marginality}{Magnitude of the marginality factor}
  \item{sf}{Specialization factor. Vector of eigenvalues of specialization}
  \item{specialization}{Square root of the mean of the specialization factor}
  \item{sf.prop}{Vector representing the proportion of specialization found in each
  ENFA factor}
  \item{co}{A matrix describing the amount of marginality and specialization
   on each ENFA factor}
  \item{ras}{RasterBrick of transformed climate values, with p layers}
  \item{weights}{Raster layer of weights used for ENFA calculation}
}
}
\description{
Performs ecological-niche factor analysis using environmental raster data and
species presence data.
}
\details{
The \code{cnfa} function is not to be confused with the \code{\link{enfa}}
function. \code{enfa} performs ENFA as described by Hirzel et al. (2002) and
Basille et al. (2008), and is offered as an alternative to the \code{enfa}
function in the \code{adehabitatHS} package. \code{CENFA::enfa} will give
different results than \code{adehabitatHS::enfa} for versions of \code{adehabitatHS}
0.3.13 or earlier, however, for two primary reasons.

First, \code{CENFA::enfa} corrects a minor mistake in the calculation of
the species covariance matrix. This correction influences the values of the
coefficients of specialization in each ecological variable, which will lead to
a different interpretation of the degree of specialization. Second, we define
the overall marginality \eqn{M} as the norm of the marginality factor \code{mf},
rather than the square of the norm of \code{mf}.

The default \code{fun = 'last'} gives equal weight to each occupied cell.
If multiple species observations occur in the same cell, the cell will only
be counted once. \code{fun = 'count'} will weight the cells by the number
of observations.

If there is too much correlation between the layers of \code{x}, the global
covariance matrix will be singular, and the overall marginality will not be
meaningful. In this case, a warning is issued and \code{marginality} is
returned as \code{NA}.
}
\examples{
mod1 <- enfa(x = climdat.hist, s.dat = ABPR, field = "CODE")

# using GLcenfa as an initial step
# for multi-species comparison

glc <- GLcenfa(x = climdat.hist)
mod2 <- enfa(x = glc, s.dat = ABPR, field = "CODE")
all.equal(m.factor(mod1), m.factor(mod2))

}
\references{
Basille, Mathieu, et al. Assessing habitat selection using multivariate
statistics: Some refinements of the ecological-niche factor analysis. Ecological
Modelling 211.1 (2008): 233-240.

Hirzel, Alexandre H., et al. Ecological-niche factor analysis: how to compute
habitat-suitability maps without absence data?. Ecology 83.7 (2002): 2027-2036.
}
\seealso{
\code{\link{GLcenfa}}, \code{\link{cnfa}}
}
