% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.R
\name{cdmFromFiles}
\alias{cdmFromFiles}
\alias{cdm_from_files}
\title{Create a CDM reference from a folder containing parquet, csv, or feather
files}
\usage{
cdmFromFiles(
  path,
  format = "auto",
  cdmVersion = "5.3",
  cdmName = NULL,
  asDataFrame = TRUE
)

cdm_from_files(
  path,
  format = "auto",
  cdm_version = "5.3",
  cdm_name = NULL,
  as_data_frame = TRUE
)
}
\arguments{
\item{path}{A folder where an OMOP CDM v5.4 instance is located.}

\item{format}{What is the file format to be read in? Must be "auto"
(default), "parquet", "csv", "feather".}

\item{cdm_version, cdmVersion}{The version of the cdm (5.3 or 5.4)}

\item{cdm_name, cdmName}{A name to use for the cdm.}

\item{as_data_frame, asDataFrame}{TRUE (default) will read files into R as dataframes.
FALSE will read files into R as Arrow Datasets.}
}
\value{
A list of dplyr database table references pointing to CDM tables
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
