%% File Name: eval_likelihood.Rd
%% File Version: 0.14

\name{eval_likelihood}
\alias{eval_likelihood}
\alias{prep_data_long_format}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Evaluation of Likelihood
}
\description{
The function \code{eval_likelihood} evaluates the likelihood given item
responses and item response probabilities.

The function \code{prep_data_long_format} stores the matrix of
item responses in a long format omitted all missing responses.
}
\usage{
eval_likelihood(data, irfprob, prior=NULL, normalization=FALSE, N=NULL)

prep_data_long_format(data)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
Dataset containing item responses in wide format or long format
(generated by \code{prep_data_long_format}).
}
  \item{irfprob}{
Array containing item responses probabilities, format
see \code{\link{IRT.irfprob}}
}
  \item{prior}{
Optional prior (matrix or vector)
}
  \item{normalization}{
Logical indicating whether posterior should be normalized
}
\item{N}{Number of persons (optional)}
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{
Numeric matrix
}

%\references{
%% ~put references to the literature/web site here ~
%}
%\author{
%%  ~~who you are~~
%}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}

\examples{
\dontrun{
#############################################################################
# EXAMPLE 1: Likelihood data.ecpe
#############################################################################

data(data.ecpe, package="CDM")
dat <- data.ecpe$dat[,-1]
Q <- data.ecpe$q.matrix

#*** store data matrix in long format
data_long <- CDM::prep_data_long_format(data)
str(data_long)

#** estimate GDINA model
mod <- CDM::gdina(dat, q.matrix=Q)
summary(mod)

#** extract data, item response functions and prior
data <- CDM::IRT.data(mod)
irfprob <- CDM::IRT.irfprob(mod)
prob_theta <- attr( irfprob, "prob.theta")

#** compute likelihood
lmod <- CDM::eval_likelihood(data=data, irfprob=irfprob)
max( abs( lmod - CDM::IRT.likelihood(mod) ))

#** compute posterior
pmod <- CDM::eval_likelihood(data=data, irfprob=irfprob, prior=prob.theta,
            normalization=TRUE)
max( abs( pmod - CDM::IRT.posterior(mod) ))
}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }% use one of  RShowDoc("KEYWORDS")
% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
