% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_weights.R
\name{sparse_weights}
\alias{sparse_weights}
\title{Computation of sparse weight matrix}
\usage{
sparse_weights(X, k, phi, connected = TRUE, scale = TRUE)
}
\arguments{
\item{X}{An \eqn{n} x \eqn{p} numeric matrix. This function assumes that each
row represents an object with \eqn{p} attributes.}

\item{k}{The number of nearest neighbors to be used for non-zero weights.}

\item{phi}{Tuning parameter of the Gaussian weights. Input should be a
nonnegative value.}

\item{connected}{If \code{TRUE}, guarantee a connected structure of the
weight matrix by using a symmetric circulant matrix to add nonzero weights.
This ensures that groups of observations that would not be connected through
weights that are based only on the k nearest neighbors are (indirectly)
connected anyway. Default is \code{TRUE}.}

\item{scale}{If \code{TRUE}, scale each squared l2-norm by the mean squared
l2-norm to ensure scale invariance of the weights. Default is \code{TRUE}.}
}
\value{
A \code{sparseweights} object containing the nonzero weights in
dictionary-of-keys format.
}
\description{
Construct a sparse weight matrix in a dictionary-of-keys format.
Each nonzero weight is computed as \eqn{exp(-phi * ||x_i - x_j||^2)}, where
the squared Euclidean distance may be scaled by the average squared Euclidean
distance, depending on the argument \code{scale}.
}
\examples{
# Load data
data(two_half_moons)
data = as.matrix(two_half_moons)
X = data[, -3]
y = data[, 3]

# Get sparse distances in dictionary of keys format with k = 5 and phi = 8
W = sparse_weights(X, 5, 8.0)

}
