% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meStack.R
\name{meStack}
\alias{meStack}
\title{meStack}
\usage{
meStack(x, y, z, agg.fun = mean, derive.stats = FALSE)
}
\arguments{
\item{x}{A \emph{list} of \emph{RasterLayer} objects or a \emph{character} vector with the paths to \emph{raster} objects.}

\item{y}{A spatial object from which an extent can be derived.}

\item{z}{Object of class \emph{Date} with the acquisition date for each element in \emph{x}.}

\item{agg.fun}{Function used to aggregate images collected in the same date. Default is the mean.}

\item{derive.stats}{Logical argument. Default is FALSE.}
}
\value{
A list containing a \emph{RasterStack} and related statistics.
}
\description{
Stacking of raster layers with different extents
}
\details{
{The function stacks the raster objects specified in \emph{x}. For each element 
in \emph{x}, the function crops it by the extent of \emph{y} and, if their extents differ, 
fits the extent of \emph{x} to the one of \emph{y}. All new pixels are set to NA. If \emph{z} 
is provided, the function will then aggregate all bands acquired in the same date using the 
function provide with \emph{agg.fun}. If \emph{derive.stats} is set to TRUE, the function will 
return basic statistics for each band (i.e. min, max, mean and sd) together with a plot of the 
mean values. The final output of the function is a list containing:
\itemize{
 \item{\emph{stack} - \emph{RasterStack} object.}
 \item{\emph{dates} - Acquisition dates for each layer in \emph{stack}.}
 \item{\emph{image.stats} - Statistics for each band in the output \emph{RasterStack}.}
 \item{\emph{stats.plot} - Plot showing the mean, minimum and maximum values per band.}
 \item{\emph{control} - Logical vector showing which elements in \emph{x} where used to build the \emph{RasterStack}.}}}
}
\examples{
{

require(raster)

r1 <- raster(xmn=1, xmx=90, ymn=1, ymx=90, res=1, vals=1) # image 1
r2 <- raster(xmn=50, xmx=150, ymn=50, ymx=150, res=1, vals=1) # image 2
r0 <- raster(xmn=20, xmx=90, ymn=50, ymx=90, res=1, vals=1) # target extent

crs(r0) <- crs(r2) <- crs(r1)

mes <- meStack(list(r1, r2), r0)
plot(mes$stack)

}
}
