#' Estimating population size via sample coverage
#' @param z the vector of capture histories or ascertainment records.
#' @return estimates based on any pair of samples
estN.pair5 <-
		function(z){
	z00001=z[1]; z00010=z[2]; z00011=z[3]; z00100=z[4];
	z00101=z[5]; z00110=z[6]; z00111=z[7]; z01000=z[8]; 
	z01001=z[9]; z01010=z[10]; z01011=z[11]; z01100=z[12];
	z01101=z[13]; z01110=z[14]; z01111=z[15]; z10000=z[16]; 
	z10001=z[17]; z10010=z[18]; z10011=z[19]; z10100=z[20];
	z10101=z[21]; z10110=z[22]; z10111=z[23]; z11000=z[24];
	z11001=z[25]; z11010=z[26]; z11011=z[27]; z11100=z[28];
	z11101=z[29]; z11110=z[30]; z11111=z[31]
	
	n1=z10000+z10001+z10010+z10011+z10100+z10101+z10110+z10111+z11000+z11001+z11010+z11011+z11100+z11101+z11110+z11111
	n2=z01000+z01001+z01010+z01011+z01100+z01101+z01110+z01111+z11000+z11001+z11010+z11011+z11100+z11101+z11110+z11111
	n3=z00100+z00101+z00110+z00111+z01100+z01101+z01110+z01111+z10100+z10101+z10110+z10111+z11100+z11101+z11110+z11111
	n4=z00010+z00011+z00110+z00111+z01010+z01011+z01110+z01111+z10010+z10011+z10110+z10111+z11010+z11011+z11110+z11111
	n5=z00001+z00011+z00101+z00111+z01001+z01011+z01101+z01111+z10001+z10011+z10101+z10111+z11001+z11011+z11101+z11111
	M1=z10000+z10001++z10010+z10011+z10100+z10101+z10110+z10111+z01000+z01001+z01010+z01011+z01100+z01101+z01110+z01111+z11000+z11001+z11010+z11011+z11100+z11101+z11110+z11111
	M2=z10000+z10001++z10010+z10011+z11000+z11001+z11010+z11011+z00100+z00101+z00110+z00111+z01100+z01101+z01110+z01111+z10100+z10101+z10110+z10111+z11100+z11101+z11110+z11111
	M3=z10000+z10001++z10100+z10101+z11000+z11001+z11100+z11101+z00010+z00011+z00110+z00111+z01010+z01011+z01110+z01111+z10010+z10011+z10110+z10111+z11010+z11011+z11110+z11111
	M4=z10000+z10010++z10100+z10110+z11000+z11010+z11100+z11110+z00001+z00011+z00101+z00111+z01001+z01011+z01101+z01111+z10001+z10011+z10101+z10111+z11001+z11011+z11101+z11111
	M5=z01000+z01001++z01010+z01011+z11000+z11001+z11010+z11011+z00100+z00101+z00110+z00111+z10100+z10101+z10110+z10111+z01100+z01101+z01110+z01111+z11100+z11101+z11110+z11111
	M6=z01000+z01001++z01100+z01101+z11000+z11001+z11100+z11101+z00010+z00011+z00110+z00111+z10010+z10011+z10110+z10111+z01010+z01011+z01110+z01111+z11010+z11011+z11110+z11111
	M7=z01000+z01010++z01100+z01110+z11000+z11010+z11100+z11110+z00001+z00011+z00101+z00111+z10001+z10011+z10101+z10111+z01001+z01011+z01101+z01111+z11001+z11011+z11101+z11111
	M8=z00100+z00101++z01100+z01101+z10100+z10101+z11100+z11101+z00010+z00011+z01010+z01011+z10010+z10011+z11010+z11011+z00110+z00111+z01110+z01111+z10110+z10111+z11110+z11111
	M9=z00100+z00110++z01100+z01110+z10100+z10110+z11100+z11110+z00001+z00011+z01001+z01011+z10001+z10011+z11001+z11011+z00101+z00111+z01101+z01111+z10101+z10111+z11101+z11111
	M10=z00010+z00110++z01010+z01110+z10010+z10110+z11010+z11110+z00001+z00101+z01001+z01101+z10001+z10101+z11001+z11101+z00011+z00111+z01011+z01111+z10011+z10111+z11011+z11111
	mm1=z11000+z11001+z11010+z11011+z11100+z11101+z11110+z11111
	mm2=z10100+z10101+z10110+z10111+z11100+z11101+z11110+z11111
	mm3=z10010+z10011+z10110+z10111+z11010+z11011+z11110+z11111
	mm4=z10001+z10011+z10101+z10111+z11001+z11011+z11101+z11111
	mm5=z01100+z01101+z01110+z01111+z11100+z11101+z11110+z11111
	mm6=z01010+z01011+z01110+z01111+z11010+z11011+z11110+z11111
	mm7=z01001+z01011+z01101+z01111+z11001+z11011+z11101+z11111
	mm8=z00110+z00111+z01110+z01111+z10110+z10111+z11110+z11111
	mm9=z00101+z00111+z01101+z01111+z10101+z10111+z11101+z11111
	mm10=z00011+z00111+z01011+z01111+z10011+z10111+z11011+z11111
	
	#(1,2)
	pet1=(n1*n2)/(mm1)
	chp1=((n1+1)*(n2+1)/(mm1)-1)
	chse1=(((n1+1)*(n2+1)*(n1-mm1)*(n2-mm1))/((mm1+1)*(mm1+1)*(mm1+2)))^0.5
	ch1=exp(1.96*(log(1+chse1^2/(chp1-M1)^2))^(0.5))
	ch1l=M1+(chp1-M1)/ch1
	ch1u=M1+(chp1-M1)*ch1
	pa12=cbind(pet1,chp1,chse1,ch1l,ch1u)
	
	#(1,3)
	pet2=(n1*n3)/(mm2)
	chp2=((n1+1)*(n3+1)/(mm2)-1)
	chse2=(((n1+1)*(n3+1)*(n1-mm2)*(n3-mm2))/((mm2+1)*(mm2+1)*(mm2+2)))^0.5
	ch2=exp(1.96*(log(1+chse2^2/(chp2-M2)^2))^(0.5))
	ch2l=M2+(chp2-M2)/ch2
	ch2u=M2+(chp2-M2)*ch2
	pa13=cbind(pet2,chp2,chse2,ch2l,ch2u)
	
	#(1,4)
	pet3=(n1*n4)/(mm3)
	chp3=((n1+1)*(n4+1)/(mm3)-1)
	chse3=(((n1+1)*(n4+1)*(n1-mm3)*(n4-mm3))/((mm3+1)*(mm3+1)*(mm3+2)))^0.5
	ch3=exp(1.96*(log(1+chse3^2/(chp3-M3)^2))^(0.5))
	ch3l=M3+(chp3-M3)/ch3
	ch3u=M3+(chp3-M3)*ch3
	pa14=cbind(pet3,chp3,chse3,ch3l,ch3u)
	
	#(1,5)
	pet4=(n1*n5)/(mm4)
	chp4=((n1+1)*(n5+1)/(mm4)-1)
	chse4=(((n1+1)*(n5+1)*(n1-mm4)*(n5-mm4))/((mm4+1)*(mm4+1)*(mm4+2)))^0.5
	ch4=exp(1.96*(log(1+chse4^2/(chp4-M4)^2))^(0.5))
	ch4l=M4+(chp4-M4)/ch4
	ch4u=M4+(chp4-M4)*ch4
	pa15=cbind(pet4,chp4,chse4,ch4l,ch4u)
	
	#(2,3)
	pet5=(n2*n3)/(mm5)
	chp5=((n2+1)*(n3+1)/(mm5)-1)
	chse5=(((n2+1)*(n3+1)*(n2-mm5)*(n3-mm5))/((mm5+1)*(mm5+1)*(mm5+2)))^0.5
	ch5=exp(1.96*(log(1+chse5^2/(chp5-M5)^2))^(0.5))
	ch5l=M5+(chp5-M5)/ch5
	ch5u=M5+(chp5-M5)*ch5
	pa23=cbind(pet5,chp5,chse5,ch5l,ch5u)
	
	#(2,4)
	pet6=(n2*n4)/(mm6)
	chp6=((n2+1)*(n4+1)/(mm6)-1)
	chse6=(((n2+1)*(n4+1)*(n2-mm6)*(n4-mm6))/((mm6+1)*(mm6+1)*(mm6+2)))^0.5
	ch6=exp(1.96*(log(1+chse6^2/(chp6-M6)^2))^(0.5))
	ch6l=M6+(chp6-M6)/ch6
	ch6u=M6+(chp6-M6)*ch6
	pa24=cbind(pet6,chp6,chse6,ch6l,ch6u)
	
	#(2,5)
	pet7=(n2*n5)/(mm7)
	chp7=((n2+1)*(n5+1)/(mm7)-1)
	chse7=(((n2+1)*(n5+1)*(n2-mm7)*(n5-mm7))/((mm7+1)*(mm7+1)*(mm7+2)))^0.5
	ch7=exp(1.96*(log(1+chse7^2/(chp7-M7)^2))^(0.5))
	ch7l=M7+(chp7-M7)/ch7
	ch7u=M7+(chp7-M7)*ch7
	pa25=cbind(pet7,chp7,chse7,ch7l,ch7u)
	
	#(3,4)
	pet8=(n3*n4)/(mm8)
	chp8=((n3+1)*(n4+1)/(mm8)-1)
	chse8=(((n3+1)*(n4+1)*(n3-mm8)*(n4-mm8))/((mm8+1)*(mm8+1)*(mm8+2)))^0.5
	ch8=exp(1.96*(log(1+chse8^2/(chp8-M8)^2))^(0.5))
	ch8l=M8+(chp8-M8)/ch8
	ch8u=M8+(chp8-M8)*ch8
	pa34=cbind(pet8,chp8,chse8,ch8l,ch8u)
	
	#(3,5)
	pet9=(n3*n5)/(mm9)
	chp9=((n3+1)*(n5+1)/(mm9)-1)
	chse9=(((n3+1)*(n5+1)*(n3-mm9)*(n5-mm9))/((mm9+1)*(mm9+1)*(mm9+2)))^0.5
	ch9=exp(1.96*(log(1+chse9^2/(chp9-M9)^2))^(0.5))
	ch9l=M9+(chp9-M9)/ch9
	ch9u=M9+(chp9-M9)*ch9
	pa35=cbind(pet9,chp9,chse9,ch9l,ch9u)
	
	#(4,5)
	pet10=(n4*n5)/(mm10)
	chp10=((n4+1)*(n5+1)/(mm10)-1)
	chse10=(((n4+1)*(n5+1)*(n4-mm10)*(n5-mm10))/((mm10+1)*(mm10+1)*(mm10+2)))^0.5
	ch10=exp(1.96*(log(1+chse10^2/(chp10-M10)^2))^(0.5))
	ch10l=M10+(chp10-M10)/ch10
	ch10u=M10+(chp10-M10)*ch10
	pa45=cbind(pet10,chp10,chse10,ch10l,ch10u)
	
	pair=(rbind(pa12,pa13,pa14,pa15,pa23,pa24,pa25,pa34,pa35,pa45))
	colnames(pair)=c("Petersen","Chapman","se","cil","ciu")
	rownames(pair)=c("pa12","pa13","pa14","pa15","pa23","pa24","pa25","pa34","pa35","pa45")
	pair
}

