\name{simdata}
\alias{simdata}

\title{
Simulate multivariate data for testing
}

\description{
Creates multivariate normal or normal and binary data, as used in the \href{../doc/simstudy.pdf}{simulation study}.
}

\usage{
simdata(n = 2000, mymean = rep(0, 4), mysigma = matrix(
	c( 1,   0.2, 0.1, -0.7,
	   0.2, 1,   0.3,  0.1,
	   0.1, 0.3, 1,    0.2,
	  -0.7, 0.1, 0.2,  1), byrow = TRUE, nrow = 4, ncol = 4),
	residsd = 1, x2binary = FALSE)
}

\arguments{
  \item{n}{
number of observations to create.
}
  \item{mymean}{
vector of length 4, giving the mean of each variable.
}
  \item{mysigma}{
variance-covariance matrix of multivariate normal distribution from which x1-x4 are to be drawn.
}
  \item{residsd}{
residual standard deviation.
}
  \item{x2binary}{
if TRUE, x2 is converted to a binary factor variable (1, 2) with probability equal
to the logistic of the underlying normally distributed variable.
}
}

\value{
Data frame with 5 columns:

\item{y}{continuous, generated by
y = x1 + x2 + x3 + normal error if x2 is continuous,
or 
y = x1 + x2 + x3 - 1 + normal error if x2 is a factor with values 1 or 2}
\item{x1}{continuous}
\item{x2}{continuous or binary (factor) with value 1 or 2}
\item{x3}{continuous}
\item{x4}{continuous}
}

\seealso{
\code{\link{makemar}}
}

\examples{
set.seed(1)
simdata(n=4, x2binary=TRUE)
#             y          x1 x2         x3        x4
# 1 -0.06399616 -1.23307320  2 -0.6521442 1.6141842
# 2  1.00822173 -0.05167026  1  0.4659907 0.5421826
# 3  2.87886825  0.43816687  1  1.5217240 0.2808691
# 4  0.79129101 -0.72510640  1  0.7342611 0.1820001
}

