/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class ConditionalProbability
extends DataPlotDialog {
    private String condDir;
    private String probDir;
    private JLabel alphaLabel;
    private JSpinner alphaSpinner;
    private JPanel analysisOptionsPane;
    private JCheckBox bootstrapCheckBox;
    private ButtonGroup condDirButtonGroup;
    private JRadioButton condDirGreaterThanRadioButton;
    private JLabel condDirLabel;
    private JRadioButton condDirLessThanRadioButton;
    private JLabel condValueLabel;
    private JSpinner condValueSpinner;
    private JPanel leftPane;
    private JPanel mainPane;
    private JLabel numBootstrapsLabel;
    private JSpinner numBootstrapsSpinner;
    private JPanel plotLabelPane;
    private JPanel plotPane;
    private JTextField plotTitle;
    private JLabel plotTitleLabel;
    private ButtonGroup probDirButtonGroup;
    private JRadioButton probDirGreaterThanEqualRadioButton;
    private JLabel probDirLabel;
    private JRadioButton probDirLessThanEqualRadioButton;
    private JComboBox responseComboBox;
    private JLabel responseLabel;
    private JComboBox stressorComboBox;
    private JLabel stressorLabel;
    private JPanel varPane;
    private JCheckBox weightsCheckBox;
    private JComboBox weightsComboBox;
    private JLabel weightsLabel;
    private JTextField xAxis;
    private JLabel xAxisLabel;
    private JTextField yAxis;
    private JLabel yAxisLabel;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalProbability.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshCondValue();
        this.refreshValidity();
        this.refreshyAxis();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshCondValue();
        this.refreshValidity();
        this.refreshyAxis();
    }

    public void refreshVariableListValidity() {
        this.stressorLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.stressorComboBox.getItemCount() > 0);
        this.stressorComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.stressorComboBox.getItemCount() > 0);
        this.responseLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.responseComboBox.getItemCount() > 0);
        this.responseComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.responseComboBox.getItemCount() > 0);
        this.weightsLabel.setEnabled(this.weightsCheckBox.isSelected());
        this.weightsComboBox.setEnabled(this.weightsCheckBox.isSelected());
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = null;
            try {
                nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
            }
            catch (REngineException ex) {
                Logger.getLogger(ConditionalProbability.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(ConditionalProbability.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.stressorComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.responseComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.weightsComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            if (this.stressorComboBox.getItemCount() > 0) {
                this.stressorComboBox.setSelectedIndex(0);
            }
            if (this.responseComboBox.getItemCount() > 0) {
                this.responseComboBox.setSelectedIndex(0);
            }
            if (this.weightsComboBox.getItemCount() > 0) {
                this.weightsComboBox.setSelectedIndex(0);
            }
        } else {
            this.stressorComboBox.removeAllItems();
            this.responseComboBox.removeAllItems();
            this.weightsComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    public void refreshCondValue() {
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 0, 0);
        if (this.responseComboBox.getItemCount() > 0) {
            String var = this.getDatasetPane().getSelectedDataset() + "$" + GUIUtils.getSelectedItem(this.responseComboBox);
            String classCmd = "class(" + var + ")";
            String rangeCmd = "range(" + var + ", na.rm=T, finite=T)";
            String meanCmd = "mean(" + var + ", na.rm=T, finite=T)";
            Vector range = null;
            Vector mean = null;
            try {
                String className = RUtils.evalAsString(classCmd);
                if (className != null && className.compareTo("numeric") == 0) {
                    boolean isMeanValid;
                    range = RUtils.evalAsVector(rangeCmd);
                    mean = RUtils.evalAsVector(meanCmd);
                    boolean isRangeValid = range != null;
                    boolean bl = isMeanValid = mean != null;
                    if (isRangeValid) {
                        double min = range.get(0) != null ? Double.parseDouble(range.get(0).toString()) : 0.0;
                        double max = range.get(1) != null ? Double.parseDouble(range.get(1).toString()) : 0.0;
                        double def = isMeanValid ? Math.rint(Double.parseDouble(mean.get(0).toString())) : 0.0;
                        double step = new Double((max - min) / 100.0).intValue();
                        step = step != 0.0 ? step : 1.0;
                        model = new SpinnerNumberModel(def, min, max, step);
                    }
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(ConditionalProbability.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(ConditionalProbability.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.condValueSpinner.setModel(model);
    }

    public void refreshOptionalParamsValidity() {
        this.numBootstrapsLabel.setEnabled(this.bootstrapCheckBox.isSelected());
        this.numBootstrapsSpinner.setEnabled(this.bootstrapCheckBox.isSelected());
    }

    public void refreshyAxis() {
        this.yAxis.setText(GUIUtils.getSelectedItem(this.responseComboBox));
    }

    public void refreshxAxis() {
        this.xAxis.setText(GUIUtils.getSelectedItem(this.stressorComboBox));
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(this.responseComboBox.getItemCount() > 0);
    }

    public void refreshValidity() {
        this.refreshVariableListValidity();
        this.refreshOptionalParamsValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.mainPane = new JPanel();
        this.leftPane = new JPanel();
        this.plotLabelPane = new JPanel();
        this.plotTitleLabel = new JLabel();
        this.plotTitle = new JTextField();
        this.xAxisLabel = new JLabel();
        this.xAxis = new JTextField();
        this.yAxisLabel = new JLabel();
        this.yAxis = new JTextField();
        this.varPane = new JPanel();
        this.stressorLabel = new JLabel();
        this.stressorComboBox = new JComboBox();
        this.responseLabel = new JLabel();
        this.responseComboBox = new JComboBox();
        this.weightsLabel = new JLabel();
        this.weightsComboBox = new JComboBox();
        this.weightsCheckBox = new JCheckBox();
        this.analysisOptionsPane = new JPanel();
        this.condDirLabel = new JLabel();
        this.condDirGreaterThanRadioButton = new JRadioButton();
        this.condDirLessThanRadioButton = new JRadioButton();
        this.condValueLabel = new JLabel();
        this.condValueSpinner = new JSpinner();
        this.probDirLabel = new JLabel();
        this.probDirGreaterThanEqualRadioButton = new JRadioButton();
        this.probDirLessThanEqualRadioButton = new JRadioButton();
        this.bootstrapCheckBox = new JCheckBox();
        this.alphaLabel = new JLabel();
        this.alphaSpinner = new JSpinner();
        this.numBootstrapsLabel = new JLabel();
        this.numBootstrapsSpinner = new JSpinner();
        this.condDirButtonGroup = new ButtonGroup();
        this.probDirButtonGroup = new ButtonGroup();
        this.mainPane.setLayout(new GridLayout(1, 2, 5, 0));
        this.plotLabelPane.setBorder(BorderFactory.createTitledBorder("Plot Labels"));
        this.plotTitleLabel.setLabelFor(this.plotTitle);
        this.plotTitleLabel.setText("Plot Title:");
        this.plotTitle.setColumns(12);
        this.plotTitle.setText("Conditional Probability");
        this.xAxisLabel.setLabelFor(this.xAxis);
        this.xAxisLabel.setText("X-Axis:");
        this.xAxis.setColumns(12);
        this.xAxis.setText("X");
        this.yAxisLabel.setLabelFor(this.yAxis);
        this.yAxisLabel.setText("Y-Axis:");
        this.yAxis.setColumns(12);
        this.yAxis.setText("Y");
        GroupLayout plotLabelPaneLayout = new GroupLayout(this.plotLabelPane);
        this.plotLabelPane.setLayout(plotLabelPaneLayout);
        plotLabelPaneLayout.setHorizontalGroup(plotLabelPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotLabelPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotLabelPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.xAxisLabel).addComponent(this.yAxisLabel).addComponent(this.plotTitleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotLabelPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xAxis, -1, 249, Short.MAX_VALUE).addComponent(this.yAxis, -1, 249, Short.MAX_VALUE).addComponent(this.plotTitle, -1, 249, Short.MAX_VALUE)).addContainerGap()));
        plotLabelPaneLayout.setVerticalGroup(plotLabelPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotLabelPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotLabelPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.plotTitleLabel).addComponent(this.plotTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotLabelPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xAxisLabel).addComponent(this.xAxis, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotLabelPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yAxisLabel).addComponent(this.yAxis, -2, -1, -2)).addContainerGap(25, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.stressorLabel.setText("Stressor:");
        this.stressorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.stressorComboBoxActionPerformed(evt);
            }
        });
        this.responseLabel.setText("Response:");
        this.responseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.responseComboBoxActionPerformed(evt);
            }
        });
        this.weightsLabel.setText("Weights:");
        this.weightsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.weightsComboBoxActionPerformed(evt);
            }
        });
        this.weightsCheckBox.setText("Specify a weighting variable");
        this.weightsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConditionalProbability.this.weightsCheckBoxStateChanged(evt);
            }
        });
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stressorLabel).addComponent(this.responseLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.responseComboBox, 0, 245, Short.MAX_VALUE).addComponent(this.stressorComboBox, 0, 245, Short.MAX_VALUE))).addComponent(this.weightsCheckBox))).addGroup(varPaneLayout.createSequentialGroup().addGap(57, 57, 57).addComponent(this.weightsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.weightsComboBox, 0, 212, Short.MAX_VALUE))).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stressorLabel).addComponent(this.stressorComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.responseLabel).addComponent(this.responseComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.weightsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.weightsLabel).addComponent(this.weightsComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout leftPaneLayout = new GroupLayout(this.leftPane);
        this.leftPane.setLayout(leftPaneLayout);
        leftPaneLayout.setHorizontalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.varPane, -1, -1, Short.MAX_VALUE).addComponent(this.plotLabelPane, -1, -1, Short.MAX_VALUE));
        leftPaneLayout.setVerticalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPaneLayout.createSequentialGroup().addComponent(this.varPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotLabelPane, -1, -1, Short.MAX_VALUE)));
        this.mainPane.add(this.leftPane);
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.condDirLabel.setText("Cutoff Value Direction:");
        this.condDirButtonGroup.add(this.condDirGreaterThanRadioButton);
        this.condDirGreaterThanRadioButton.setText("Greater Than");
        this.condDirGreaterThanRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.condDirGreaterThanRadioButtonActionPerformed(evt);
            }
        });
        this.condDirButtonGroup.add(this.condDirLessThanRadioButton);
        this.condDirLessThanRadioButton.setSelected(true);
        this.condDirLessThanRadioButton.setText("Less Than");
        this.condDirLessThanRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.condDirLessThanRadioButtonActionPerformed(evt);
            }
        });
        this.condValueLabel.setLabelFor(this.condValueSpinner);
        this.condValueLabel.setText("Response Cutoff Value:");
        this.condValueSpinner.setModel(new SpinnerNumberModel((Number)0.0, null, null, (Number)0.0));
        this.probDirLabel.setText("Probability Direction:");
        this.probDirButtonGroup.add(this.probDirGreaterThanEqualRadioButton);
        this.probDirGreaterThanEqualRadioButton.setSelected(true);
        this.probDirGreaterThanEqualRadioButton.setText("Greater Than or Equal");
        this.probDirGreaterThanEqualRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.probDirGreaterThanEqualRadioButtonActionPerformed(evt);
            }
        });
        this.probDirButtonGroup.add(this.probDirLessThanEqualRadioButton);
        this.probDirLessThanEqualRadioButton.setText("Less Than or Equal");
        this.probDirLessThanEqualRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.probDirLessThanEqualRadioButtonActionPerformed(evt);
            }
        });
        this.bootstrapCheckBox.setText("Bootstrap confidence intervals");
        this.bootstrapCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConditionalProbability.this.bootstrapCheckBoxStateChanged(evt);
            }
        });
        this.bootstrapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.bootstrapCheckBoxActionPerformed(evt);
            }
        });
        this.alphaLabel.setText("Confidence Interval Alpha:");
        this.alphaSpinner.setModel(new SpinnerNumberModel(0.05, 0.01, 1.0, 0.01));
        this.numBootstrapsLabel.setText("Number of Bootstraps:");
        this.numBootstrapsSpinner.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)1));
        GroupLayout analysisOptionsPaneLayout = new GroupLayout(this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout(analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addComponent(this.condValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.condValueSpinner, -2, 120, -2)).addComponent(this.condDirLabel))).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addGap(72, 72, 72).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.condDirGreaterThanRadioButton).addComponent(this.condDirLessThanRadioButton))).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.probDirLabel)).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addGap(75, 75, 75).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.probDirGreaterThanEqualRadioButton).addComponent(this.probDirLessThanEqualRadioButton))).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.alphaLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alphaSpinner, -2, 100, -2)).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.bootstrapCheckBox)).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addGap(53, 53, 53).addComponent(this.numBootstrapsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numBootstrapsSpinner, -2, 80, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.condValueLabel).addComponent(this.condValueSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.condDirLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.condDirGreaterThanRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.condDirLessThanRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.probDirLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.probDirGreaterThanEqualRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.probDirLessThanEqualRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.alphaLabel).addComponent(this.alphaSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numBootstrapsLabel).addComponent(this.numBootstrapsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.mainPane.add(this.analysisOptionsPane);
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.mainPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addComponent(this.mainPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.setTitle("Conditional Probability");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 810) / 2, (screenSize.height - 598) / 2, 810, 598);
    }

    private void responseComboBoxActionPerformed(ActionEvent evt) {
        this.refreshCondValue();
        this.refreshyAxis();
    }

    private void bootstrapCheckBoxStateChanged(ChangeEvent evt) {
        this.refreshOptionalParamsValidity();
    }

    private void condDirGreaterThanRadioButtonActionPerformed(ActionEvent evt) {
        this.setConditionalValueDirection(">");
    }

    private void condDirLessThanRadioButtonActionPerformed(ActionEvent evt) {
        this.setConditionalValueDirection("<");
    }

    private void probDirGreaterThanEqualRadioButtonActionPerformed(ActionEvent evt) {
        this.setProbabilityDirection(">=");
    }

    private void probDirLessThanEqualRadioButtonActionPerformed(ActionEvent evt) {
        this.setProbabilityDirection("<=");
    }

    private void weightsComboBoxActionPerformed(ActionEvent evt) {
    }

    private void weightsCheckBoxStateChanged(ChangeEvent evt) {
        this.refreshVariableListValidity();
    }

    private void bootstrapCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void stressorComboBoxActionPerformed(ActionEvent evt) {
        this.refreshxAxis();
    }

    @Override
    protected void submitButtonAction() {
        PreferencesManager prefsManager = new PreferencesManager();
        try {
            prefsManager.importPreferences();
        }
        catch (Exception ex) {
            Logger.getLogger(ConditionalProbability.class.getName()).log(Level.INFO, null, ex);
        }
        String cmd = "conditionalprob.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", x=" + GUIUtils.getSelectedItemR(this.stressorComboBox) + ", y=" + GUIUtils.getSelectedItemR(this.responseComboBox) + ", weights=" + (this.weightsCheckBox.isSelected() ? GUIUtils.getSelectedItemR(this.weightsComboBox) : "NULL") + ", cond.val=" + this.condValueSpinner.getValue() + ", cond.val.direction=" + (this.getConditionalValueDirection() == null ? "'<'" : RUtils.getStringValue(this.getConditionalValueDirection())) + ", prob.direction=" + (this.getProbabilityDirection() == null ? "'>='" : RUtils.getStringValue(this.getProbabilityDirection())) + ", alpha=" + this.alphaSpinner.getValue() + ", R=" + (this.bootstrapCheckBox.isSelected() ? this.numBootstrapsSpinner.getValue() : "NULL") + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", main=" + RUtils.getStringValue(this.plotTitle.getText()) + ", xlab=" + RUtils.getStringValue(this.xAxis.getText()) + ", ylab=" + RUtils.getStringValue(this.yAxis.getText()) + ", " + prefsManager.getCadstatPreferences().toString() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('conditionalprob.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    public String getConditionalValueDirection() {
        return this.condDir;
    }

    public void setConditionalValueDirection(String condDir) {
        this.condDir = condDir;
    }

    public String getProbabilityDirection() {
        return this.probDir;
    }

    public void setProbabilityDirection(String probDir) {
        this.probDir = probDir;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object s = this.stressorComboBox.getSelectedItem();
        Object r = this.responseComboBox.getSelectedItem();
        Object w = this.weightsComboBox.getSelectedItem();
        this.getDatasetPane().refreshDatasetComboBox();
        this.refreshFactorSelectionPanes();
        this.stressorComboBox.setSelectedItem(s);
        this.responseComboBox.setSelectedItem(r);
        this.weightsComboBox.setSelectedItem(w);
        this.refreshValidity();
    }
}

