% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_source.R
\name{treesource}
\alias{treesource}
\title{The number of trees of each source that belong to each cluster}
\usage{
treesource(source, clustering)
}
\arguments{
\item{source}{A vector with the name of the source on which each tree in the forest was based}

\item{clustering}{A vector with the clusternumber to which each tree belongs}
}
\value{
\item{multiplot}{For each outcome variable, a bar plot with the number of trees that belong to each cluster}
\item{heatmap}{A heatmap with for each outcome variable, the number of trees that belong to each cluster}
}
\description{
Function to visualize the number of trees from each source that belong to each cluster.
}
\examples{
#Grow forest based on multiple outcome variables, with 5 trees for each outcome variable
forest <- growforest(drugs, X = c("Age", "Gender", "Edu", "Neuro", "Extr", "Open", "Agree",
 "Consc", "Impul","Sensat"), Y = c("Amphet", "Benzos", "Coke", "Ecst"), ntrees = 5)

#Calculate similarities between the trees in the forest
simmatrix1 <- similarities(fulldata = drugs, treedata = forest[[2]], Y = rep(c("Amphet",
 "Benzos", "Coke", "Ecst"), each = 5), 
 X = c("Age", "Gender", "Edu", "Neuro", "Extr", "Open", "Agree", "Consc", "Impul","Sensat"),
 trees = forest[[1]], m = 1, weight = 0)

#Cluster the trees in the forest 
clusters <- clusterforest(simmatrix=simmatrix1, trees= forest[[1]], fulldata=drugs, 
treedata=forest[[2]], Y = rep(c("Amphet",
 "Benzos", "Coke", "Ecst"), each = 5), 
 fromclus=3, toclus=3)

#Visualize the number of trees for each source that belong to each cluster
treesource(source = rep(c("Amphet", "Benzos", "Coke", "Ecst"), each = 5),
clustering = clusters $ clusters[[3]])
}
