% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAmatrix.R
\name{calcAmatrix}
\alias{calcAmatrix}
\title{Calculate an additive relationship matrix}
\usage{
calcAmatrix(pedColumns, aMatIn = NULL)
}
\arguments{
\item{pedColumns}{A data.frame with four columns. The first column
has to be the row number and sire and dam columns refer directly to rows
of the pedigree. Parents of founders need to be set to 0 (ZERO). The row
of a child has to be after (i.e. a higher row number) that of its parents.
If an individual has one known and one unknown parent, set the unknown
parent to 0. The fourth column indicates: If negative, the individual is
a DH: the F1 is created, generates a gamete, which is then doubled.
If positive, the number of generations an individual was self-pollinated
after it's F1 ancestor was created (can be 0 if the individual is the F1).}

\item{aMatIn}{A square matrix that contains the additive relationship
matrix between individuals at the beginning of the pedigree. If given,
the function saves time by starting calculations after those individuals
This aMatIn functionality is NOT compatible with calculating A inverse}
}
\value{
A matrix, \code{aMat}, the additive relationship matrix
}
\description{
\code{pedigreeToAmatrix} returns an additive relationship matrix from a
 pedigree specified in three columns. The first column has to be the row
 number and sire and dam columns refer directly to rows of the pedigree.
}
\details{
\code{pedigreeToAmatrix} has some functionality useful for plants.  It can
 handle a pedigree of doubled haploid lines. Individuals can be
 self-pollinated for an arbitrary number of generations.
}
