% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{fill_bone_points}
\alias{fill_bone_points}
\title{Fills bone with orthogonally spaced points for internal analysis}
\usage{
fill_bone_points(surface_mesh, spacing)
}
\arguments{
\item{surface_mesh}{Mesh object}

\item{spacing}{Numeric}
}
\value{
Matrix with internal point coordinates
}
\description{
Fills bone with orthogonally spaced points for internal analysis
}
\examples{
\donttest{
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)
  internal_fill <- fill_bone_points(surface_mesh, 2)
}
}
