% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_oc.R
\name{estimate_oc}
\alias{estimate_oc}
\title{Estimate organic carbon content}
\usage{
estimate_oc(
  df = NULL,
  core = "core",
  site = "site",
  ecosystem = "ecosystem",
  species = "species",
  om = "om",
  oc = "oc"
)
}
\arguments{
\item{df}{A tibble or data.frame containing all the data. Must have at least
five columns (see arguments below).}

\item{core}{Character Name of the column with the id of the core to which
the sample belongs}

\item{site}{Character Name of the column reporting sample site.}

\item{ecosystem}{Character Name of the column reporting ecosystem type.
To apply published equations for OC estimation, ecosystem names should be
either "Salt Marsh", "Seagrass" or "Mangrove".}

\item{species}{Character Name of the column reporting the main species in the site.}

\item{om}{Character Name of the column reporting organic matter values.}

\item{oc}{Character Name of the column reporting organic carbon values.}
}
\value{
The initial tibble or data.frame with three new columns:
\itemize{
\item one column with estimated organic carbon values (eOC) in \%
\item the standard error of the prediction (eOC_se)
\item the type of model used for estimation (origin)
}

In addition, a plot with the relationship between organic matter and estimated
organic carbon values.
}
\description{
Estimate organic carbon from organic matter values
}
\details{
Estimation of organic Carbon is done by means of linear regressions on
log(organic carbon) ~ log(organic matter), which return estimated organic carbon
value for each organic matter value provided. If there is a value for organic carbon
for that sample it returns the same value; otherwise, it estimates organic carbon
from a model fitted to that site, or a model fitted to that species, or else
a model fitted to that ecosystem. If there are too few samples (<10) to build a
reliable model or the model fit is too poor (r2 < 0.5), \code{\link[=estimate_oc]{estimate_oc()}} uses the equations
in Fourqurean et al. (2012) \doi{10.1038/ngeo1477} for seagrasses,
Maxwell et al. (2023) \doi{10.1038/s41597-023-02633-x} for salt marshes
and Piñeiro-Juncal (in prep.) for mangroves to estimate the organic carbon.
}
\examples{
bluecarbon_decompact <- decompact(bluecarbon_data)
out <- estimate_oc(bluecarbon_decompact)
head(out$data)
out$models
}
