% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_based.R
\name{GetCTP}
\alias{GetCTP}
\title{Return cell type proportions from bulk}
\usage{
GetCTP(bulk, cell_types, markers, ct_col, gene_col, min_gene, max_gene,
  weighted, w_col, verbose)
}
\arguments{
\item{bulk}{Expression Set containing bulk data}

\item{cell_types}{Character vector. Names of cell types.}

\item{markers}{Data frame with columns specifying cluster and gene,
and optionally a column for weights, typically the fold-change of the gene.
Important that the genes for each cell type are row-sorted by signficance.}

\item{ct_col}{Character string. Column name specifying cluster/cell type
corresponding to each marker gene in \strong{markers}.}

\item{gene_col}{Character string. Column name specifying gene names in
\strong{markers}.}

\item{min_gene}{Numeric. Min number of genes to use for each cell type.}

\item{max_gene}{Numeric. Max number of genes to use for each cell type.}

\item{weighted}{Boolean. Whether to use weights for gene prioritization}

\item{w_col}{Character string. Column name for weights, such as "avg_logFC",
in \strong{markers}}

\item{verbose}{Boolean. Whether to print log info during decomposition.
Errors will be printed regardless.}
}
\value{
A List. Slot \strong{cors} contains list of vectors with correlation
  coefficients. Slot \strong{ctps} contains list of CTP objects returned by
  GetCTP
}
\description{
Calculate cell type proportions from a data frame containing bulk expression
values. Uses PCA (weighted or regular) to estimate relative proportions
within each cell type.
}
