% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_LogBip.R
\name{proj_LogBip}
\alias{proj_LogBip}
\title{Fitting a Binary Logistic Biplot with Missing Data Using Data Projection and a Block Coordinate Descending Algorithm}
\usage{
proj_LogBip(x, k = 2, max_iters = 1000, random_start = FALSE, epsilon = 1e-05)
}
\arguments{
\item{x}{binary matrix.}

\item{k}{dimensions number. By default \code{k = 2}.}

\item{max_iters}{maximum iterations.}

\item{random_start}{random initialization}

\item{epsilon}{convergence criteria}
}
\value{
Imputed \eqn{X} matrix and coordenates of the matrix A and B, and \eqn{\mu}
}
\description{
This function impute the missing values of a binary dataset \eqn{X}, and estimates the vector \eqn{\mu}, matrix A and matrix B using data projection model with a block coordinate descending algorithm.
}
\examples{
\donttest{
data("Methylation")
set.seed(12345)
n <- nrow(Methylation)
p <- ncol(Methylation)
miss <- matrix(rbinom(n*p, 1, 0.2), n, p) #I simulate some missing data
miss <- ifelse(miss == 1, NA, miss)
x <- Methylation + miss  #Matrix containing missing data
out <- LogBip(x, method = "PDLB", maxit = 1000)
}
}
\references{
Babativa-Marquez, J. G., & Vicente-Villardon, J. L. (2022). Logistic biplot with missing data.
Babativa-Marquez, J. G., & Vicente-Villardon, J. L. (2021). Logistic Biplot by Conjugate Gradient Algorithms and Iterated SVD. Mathematics, 9(16).
Vicente-Villardon, J.L. and Galindo, M. Purificacion (2006), \emph{Multiple Correspondence Analysis and related Methods. Chapter: Logistic Biplots}. Chapman-Hall
}
\seealso{
\code{\link{cv_LogBip}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
