% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogBip.R
\name{LogBip}
\alias{LogBip}
\title{Fitting a Binary Logistic Biplot using optimization methods}
\usage{
LogBip(
  x,
  k = 2,
  method = "MM",
  type = NULL,
  plot = TRUE,
  maxit = NULL,
  endsegm = 0.9,
  label.ind = FALSE,
  col.ind = NULL,
  draw = c("biplot", "ind", "var"),
  random_start = FALSE,
  truncated = TRUE,
  L = 0
)
}
\arguments{
\item{x}{Binary matrix.}

\item{k}{Dimensions number. By default \code{k = 2}.}

\item{method}{Method to be used to estimate the parameters. By default \code{method="CG"}}

\item{type}{For the conjugate-gradients method. Takes value 1 for the Fletcher–Reeves update, 2 for Polak–Ribiere and 3 for Beale–Sorenson.}

\item{plot}{Plot the Bootstrap Logistic Biplot.}

\item{maxit}{The maximum number of iterations. Defaults to 100 for the gradient methods, and 500 without gradient.}

\item{endsegm}{The segment starts at 0.5 and ends at this value. By default \code{endsegm = 0.90}.}

\item{label.ind}{By default the row points are not labelled.}

\item{col.ind}{Color for the rows marks.}

\item{draw}{The graph to draw ("ind" for the individuals, "var" for the variables and "biplot" for the row and columns coordinates in the same graph)}

\item{random_start}{Logical value; whether to randomly inititalize the parameters. If \code{FALSE},
algorithm will use an SVD as starting value.}

\item{truncated}{Find the k largest singular values and vectors of a matrix.}

\item{L}{Penalization parameter. By default \code{L = 0}.}
}
\value{
Coordenates of the matrix A and B, threshold for classification rule
}
\description{
This function estimates the vector \eqn{\mu}, matrix A and matrix B using the optimization algorithm chosen by the user and applies a bootstrap methodology to determine the confidence ellipses.
}
\details{
The methods that can be used to estimate the parameters of a logistic biplot

- For methods based on the conjugate gradient use method = "CG" and

      - type = 1 for the Fletcher Reeves.
      - type = 2 for Polak Ribiere.
      - type = 3 for Hestenes Stiefel.
      - type = 4 for Dai Yuan.

- To use the iterative coordinate descendent MM algorithm then method = "MM".

- To use the BFGS formula, method = "BFGS".
}
\examples{
\donttest{
data("Methylation")
res <- LogBip(x = Methylation, method = "MM", maxit = 1000)
}
}
\references{
Babativa-Marquez, J.G. and Vicente-Villardon, J.L. (2021). Logistic biplot by conjugate gradient algorithms and iterated SVD. Mathematics 2021.

John C. Nash (2011). Unifying Optimization Algorithms to Aid Software System Users:optimx for R. Journal of Statistical Software. 43(9). 1--14.

John C. Nash (2014). On Best Practice Optimization Methods in R. Journal of Statistical Software. 60(2). 1--14.

Nocedal, J.;Wright, S. (2006). Numerical optimization; Springer Science & Business Media.

Vicente-Villardon, J.L. and Galindo, M. Purificacion (2006), \emph{Multiple Correspondence Analysis and related Methods. Chapter: Logistic Biplots}. Chapman-Hall
}
\seealso{
\code{\link{plotBLB}, \link{pred_LB}, \link{fitted_LB}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
