% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfam_plot.R
\name{pfam_plot}
\alias{pfam_plot}
\title{pfam_plot}
\usage{
pfam_plot(
  pfam_file,
  the_order = NULL,
  domain_select = NULL,
  shape = "RoundRect",
  r = 0.3,
  legend_size = 15,
  domain_color = NULL
)
}
\arguments{
\item{pfam_file}{The path of meme file or mast file.}

\item{the_order}{The path of order file. A List of Gene ID , One ID Per Line.}

\item{domain_select}{The domain ID which you want to align with.}

\item{shape}{RoundRect or Rect.}

\item{r}{The radius of rounded corners.}

\item{legend_size}{The size of legend.}

\item{domain_color}{The color set of domain.}
}
\value{
p
}
\description{
Visualization of domain in pfam result file
}
\examples{
pfam_path <- system.file("extdata", "iprscan.tsv", package = "BioVizSeq")
order_path <- system.file("extdata", "order.csv", package = "BioVizSeq")
pfam_plot(pfam_path)
pfam_plot(pfam_path, the_order=order_path)

}
\author{
Shiqi Zhao
}
