% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{fixcut_sur}
\alias{fixcut_sur}
\title{Fixed Cutoff Analysis for Individual Biomarker Associated with Survival Outcome}
\usage{
fixcut_sur(
  yvar,
  censorvar,
  xvar,
  dir,
  cutoffs,
  data,
  method = "logrank",
  yvar.display = yvar,
  xvar.display = xvar,
  vert.x = FALSE
)
}
\arguments{
\item{yvar}{Survival response variable name.}

\item{censorvar}{Censoring variable. 0 indicates censored, 1 indicates an event.}

\item{xvar}{Biomarker name.}

\item{dir}{Cutoff direction for the desired subgroup.
Options are ">", ">=", "<", or "<=".}

\item{cutoffs}{A vector of candidate cutoffs.}

\item{data}{The dataset containing the variables.}

\item{method}{Method for cutoff selection.
Currently only supports "logrank".
- "logrank": Minimizes the logrank test p-value.}

\item{yvar.display}{Display name of the response variable.}

\item{xvar.display}{Display name of the predictor variable.}

\item{vert.x}{Whether to display the cutoff in a 90-degree angle when plotting (saves space).}
}
\value{
A list containing statistical summaries, selected cutoff statistics, selected cutoff value, group statistics,
        and a ggplot object for visualization.
}
\description{
This function conducts fixed cutoff analysis for Individual Biomarker Associated with survival outcome variables.
}
