% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{fixcut_bin}
\alias{fixcut_bin}
\title{Fixed Cutoff Analysis for Individual Biomarker Associated with Binary Outcome Variables}
\usage{
fixcut_bin(
  yvar,
  xvar,
  dir,
  cutoffs,
  data,
  method = "Fisher",
  yvar.display = yvar,
  xvar.display = xvar,
  vert.x = FALSE
)
}
\arguments{
\item{yvar}{Binary response variable name. 0 represents controls and 1 represents cases.}

\item{xvar}{Biomarker name.}

\item{dir}{Cutoff direction for the desired subgroup. Options are ">", ">=", "<", or "<=".}

\item{cutoffs}{A vector of candidate cutoffs.}

\item{data}{The dataset containing the variables.}

\item{method}{Method for cutoff selection. Options are "Fisher", "Youden", "Conc.Prob", "Accuracy", or "Kappa".
- "Fisher": Minimizes the Fisher test p-value.
- "Youden": Maximizes the Youden index.
- "Conc.Prob": Maximizes sensitivity * specificity.
- "Accuracy": Maximizes accuracy.
- "Kappa": Maximizes Kappa coefficient.}

\item{yvar.display}{Display name of the response variable.}

\item{xvar.display}{Display name of the predictor variable.}

\item{vert.x}{Whether to display the cutoff in a 90-degree angle when plotting (saves space).}
}
\value{
A list containing statistical summaries, selected cutoff statistics, selected cutoff value, confusion matrix,
        and a ggplot object for visualization.
}
\description{
This function conducts fixed cutoff analysis for individual biomarker associated with binary outcome variables.
}
