% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/501-extractProtAAC.R
\name{extrProtAAC}
\alias{extrProtAAC}
\title{Amino Acid Composition Descriptor}
\usage{
extrProtAAC(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 20 named vector
}
\description{
Amino Acid Composition Descriptor
}
\details{
This function calculates the Amino Acid Composition descriptor (Dim: 20).
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'BioMedR'))[[1]]
extrProtAAC(x)

}
\references{
M. Bhasin, G. P. S. Raghava.
Classification of Nuclear Receptors Based on 
Amino Acid Composition and Dipeptide Composition. 
\emph{Journal of Biological Chemistry}, 2004, 279, 23262.
}
\seealso{
See \code{\link{extrProtDC}} and \code{\link{extrProtTC}} 
         for Dipeptide Composition and Tripeptide Composition descriptors.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>,
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{AAC}
\keyword{Acid}
\keyword{Amino}
\keyword{Composition}
\keyword{extrProtACC}
\keyword{extract}
