% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioCircos.R
\name{BioCircosBarTrack}
\alias{BioCircosBarTrack}
\title{Create a track with a bar plot to be added to a BioCircos tracklist}
\usage{
BioCircosBarTrack(trackname, chromosomes, starts, ends, values, labels = "",
  maxRadius = 0.9, minRadius = 0.5, color = "#40B9D4", range = 0, ...)
}
\arguments{
\item{trackname}{The name of the new track.}

\item{chromosomes}{A vector containing the chromosomes on which each bar is found.
Values should match the chromosome names given in the genome parameter of the BioCircos function.}

\item{starts, ends}{Vectors containing the coordinates on which each bin begins or ends.}

\item{values}{A vector of numerical values associated with each bin, used to determine the 
height of each bar on the track.}

\item{labels}{One or multiple character objects to label each bar.}

\item{minRadius, maxRadius}{Where the track should begin and end, in proportion of the inner radius of the plot.}

\item{color}{The color for the bars, in hexadecimal RGB format.}

\item{range}{Vector of values to be mapped to the minimum and maximum radii of the track.
Default to 0, mapping the minimal and maximal values input in the values parameter.}

\item{...}{Ignored}
}
\description{
Bins are defined by a genomic range and associated with a numerical value
}
\examples{
BioCircos(BioCircosBarTrack('BarTrack', chromosomes = 1:3, starts = 1e+7*2:4, ends = 2.5e+7*2:4, 
  values = 1:3, labels = c('A ', 'B ', 'C '), range = c(0,4)) + BioCircosBackgroundTrack('BGTrack'))

}
