% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioCircos.R
\name{BioCircosBackgroundTrack}
\alias{BioCircosBackgroundTrack}
\title{Create a background track to be added to a BioCircos tracklist}
\usage{
BioCircosBackgroundTrack(trackname, fillColors = "#EEEEFF",
  borderColors = "#000000", maxRadius = 0.9, minRadius = 0.5,
  borderSize = 0.3, ...)
}
\arguments{
\item{trackname}{The name of the new track.}

\item{fillColors}{The color of the background element, in hexadecimal RGB format.}

\item{borderColors}{The color of the background borders, in hexadecimal RGB format.}

\item{minRadius, maxRadius}{Where the track should begin and end, in proportion of the inner radius of the plot.}

\item{borderSize}{The thickness of the background borders.}

\item{...}{Ignored}
}
\description{
Simple background to display behind another track
}
\examples{
BioCircos(BioCircosBackgroundTrack('bgTrack', fillColors="#FFEEEE", borderSize = 1))

}
