% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdNormalize_Data}
\alias{bdNormalize_Data}
\title{Normalize Delayed Array matrix}
\usage{
bdNormalize_Data(X, bcenter = NULL, bscale = NULL)
}
\arguments{
\item{X}{numerical or Delayed Array Matrix}

\item{bcenter}{logical (default = TRUE) if TRUE, centering is done by subtracting the column means}

\item{bscale}{logical (default = TRUE) if TRUE, centering is done by subtracting the column means}
}
\value{
numerical matrix
}
\description{
This function performs a numerical or Delayed Array matrix normalization
}
\examples{
library(DelayedArray)

m <- 500
n <- 100 
x <- matrix(rnorm(m*n), nrow=m, ncol=n)

# with numeric matrix
bdNormalize_Data(x)

# with Delaeyd Array
Dx <- DelayedArray(x)

# Center and scale
bdNormalize_Data(Dx)

# Only scale
bdNormalize_Data(Dx, bcenter = FALSE)

# Only center
bdNormalize_Data(Dx, bscale = FALSE)

}
