# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Matrix Crossprod with R-objects and Delayed Array Object
#' 
#' This function performs a Crossproduct with weigths matrix t(A)%*%W%*%A multiplication with numeric matrix or Delayed Arrays
#' 
#' @param A a double matrix.
#' @param W a Weighted matrix
#' @param block_size (optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)
#' @param paral, (optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation
#' @param threads (optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available
#' @return Matrix with t(A)%*%W%*%A product 
#' @examples
#' 
#' library(DelayedArray)
#' 
#' # with numeric matrix
#' m <- 500
#' k <- 1500
#' n <- 400
#' A <- matrix(rnorm(n*k), nrow=n, ncol=k)
#' B <- matrix(rnorm(n*k), nrow=k, ncol=n)
#' 
#' # Serial execution
#' Serie <- bdCrossprod_Weighted(A, B, paral = FALSE)
#' 
#' # Parallel execution with 2 threads and blocks 256x256
#' Par_2cor <- bdCrossprod_Weighted(A, B, paral = TRUE, block_size = 256, threads = 2)
#' 
#' @export
bdCrossprod_Weighted <- function(A, W, block_size = NULL, paral = NULL, threads = NULL) {
    .Call('_BigDataStatMeth_bdCrossprod_Weighted', PACKAGE = 'BigDataStatMeth', A, W, block_size, paral, threads)
}

#' Remove SNPs in hdf5 omic dataset with low data
#'
#' Remove SNPs in hdf5 omic dataset with low data
#' 
#' @param filename, character array indicating the name of the file to create
#' @param group, character array indicating the input group where the data set to be imputed is. 
#' @param dataset, character array indicating the input dataset to be imputed
#' @param outgroup, character array indicating group where the data set will be saved after remove data with if `outgroup` is NULL, output dataset is stored in the same input group. 
#' @param outdataset, character array indicating dataset to store the resulting data after imputation if `outdataset` is NULL, input dataset will be overwritten. 
#' @param pcent, by default pcent = 0.5. Numeric indicating the percentage to be considered to remove SNPs, SNPS with percentage equal or higest will be removed from data
#' @param bycols, boolean by default = true, if true, indicates that SNPs are in cols, if SNPincols = false indicates that SNPs are in rows.
#' @return Original hdf5 data file with imputed data
#' @export
bdRemovelowdata <- function(filename, group, dataset, outgroup, outdataset, pcent, bycols) {
    .Call('_BigDataStatMeth_bdRemovelowdata', PACKAGE = 'BigDataStatMeth', filename, group, dataset, outgroup, outdataset, pcent, bycols)
}

#' Apply function to different datasets inside a group
#'
#' Apply function to different datasets inside a group
#' 
#' @param filename, Character array, indicating the name of the file to create
#' @param group, Character array, indicating the input group where the data set to be imputed is. 
#' @param datasets, Character array, indicating the input datasets to be used
#' @param outgroup, Character, array, indicating group where the data set will be saved after imputation if `outgroup` is NULL, output dataset is stored in the same input group. 
#' @param func, Character array, function to be applyed : 
#' QR to apply bdQR() function to datasets
#' CrossProd to apply bdCrossprod() function to datasets
#' tCrossProd to apply bdtCrossprod() function to datasets
#' invChol to apply bdInvCholesky() function to datasets
#' blockmult to apply matrix multiplication, in that case, we need the datasets to be used defined
#'     in b_datasets variable, datasets and b_datasets must be of the same lenght, in that case, the operation is performed according to index, for example,
#'     if we have datasets = {"A1", "A2", "A3} and b_datasets = {"B1", "B2", "B3}, the functions performs : A1%*%B1, A2%*%B2 and A3%*%B3 
#' CrossProd_double to  performs crossprod using two matrices, see blockmult 
#' tCrossProd_double to  performs transposed crossprod using two matrices, see blockmult 
#' solve to solve matrix equation system, see blockmult for parametrization 
#' @param b_group, optional Character array indicating the input group where data are stored when we need a second dataset to operate, for example in functions like matrix multiplication
#' @param b_datasets, optional Character array indicating the input datasets to be used when we need a second dataset in functions like matrix multiplication
#' @param force, optional Boolean if true, previous results in same location inside hdf5 will be overwritten, by default force = false, data was not overwritten..
#' @return Original hdf5 data file with results after apply function to different datasets
#' @export
bdapply_Function_hdf5 <- function(filename, group, datasets, outgroup, func, b_group = NULL, b_datasets = NULL, force = FALSE) {
    invisible(.Call('_BigDataStatMeth_bdapply_Function_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, datasets, outgroup, func, b_group, b_datasets, force))
}

#' Bind matrices by rows or columns
#'
#' Merge existing matrices inside hdf5 data file by rows or by columns
#' 
#' @param filename, character array indicating the name of the file to create
#' @param group, character array indicating the input group where the data set to be imputed is. 
#' @param datasets, character array indicating the input dataset to be imputed
#' @param outgroup, character array indicating group where the data set will be saved after imputation if `outgroup` is NULL, output dataset is stored in the same input group. 
#' @param outdataset, character array indicating the name for the new merged dataset
#' @param func, character array function to be applyed
#' \describe{
#'     \item{bindRows}{merge datasets by rows}
#'     \item{bindCols}{apply datasets by columns}
#' }
#' @param force, boolean if true, previous results in same location inside hdf5 will be overwritten.
#' @return Original hdf5 data file with results after input datasets
#' @export
bdBind_hdf5 <- function(filename, group, datasets, outgroup, outdataset, func, force = FALSE) {
    invisible(.Call('_BigDataStatMeth_bdBind_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, datasets, outgroup, outdataset, func, force))
}

#' Crossprod with hdf5 matrix
#' 
#' This function performs the crossprod from a matrix inside and hdf5 data file
#' 
#' @param filename string file name where dataset to normalize is stored
#' @param group, string, group name where dataset A is stored
#' @param A string name inside HDF5 file
#' @param groupB, string, group name where dataset b is stored
#' @param B string, dataset name for matrix B inside HDF5 file
#' @param block_size (optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)
#' @param paral, (optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation
#' @param threads (optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available
#' @param mixblock_size (optional) only for debug pourpose
#' @param outgroup (optional) group name to store results from Crossprod inside hdf5 data file
#' @examples
#'   
#'   library(BigDataStatMeth)
#'   library(rhdf5)
#'      
#'   matA <- matrix(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15), nrow = 3, byrow = TRUE)
#'   matB <- matrix(c(15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,5,3,4,5,2,6,2,3,4,
#'                    42, 23, 23, 423,1,2), nrow = 3, byrow = TRUE)
#'   
#'   bdCreate_hdf5_matrix_file("BasicMatVect.hdf5", matA, "INPUT", "matA")
#'   bdAdd_hdf5_matrix(matB, "BasicMatVect.hdf5", "INPUT", "matB")
#'   
#'   res <- bdCrossprod_hdf5("BasicMatVect.hdf5", "INPUT","matA", block_size = 3)
#'   res2 <- bdCrossprod_hdf5("BasicMatVect.hdf5", "INPUT",
#'                            "matA", "INPUT","matB", block_size = 3)
#'   
#'   # Examine hierarchy before open file
#'   h5ls("BasicMatVect.hdf5")
#'   
#'   # Open file
#'   h5fdelay = H5Fopen("BasicMatVect.hdf5")
#'   
#'   # Show hdf5 hierarchy (groups)
#'   h5fdelay
#'   
#'   res <- h5fdelay$OUTPUT$CrossProd_matAxmatA
#'   res2 <- h5fdelay$OUTPUT$CrossProd_matAxmatB
#'   
#'   all.equal(crossprod(matA), res)
#'   all.equal(crossprod(matA,matB), res2)
#'   
#'   # Close delayed.hdf5 file
#'   H5Fclose(h5fdelay)
#'   
#'   # Remove file (used as example)
#'   if (file.exists("BasicMatVect.hdf5")) {
#'     # Delete file if it exist
#'     file.remove("BasicMatVect.hdf5")
#'   }
#'   
#' @return If all process is ok, returns a list with : 
#' \itemize{
#'   \item{"filename"}{ File name where results are storesd }
#'   \item{"dataset"}{ route to results inside hdf5 data file }
#' }
#' 
#' @export
bdCrossprod_hdf5 <- function(filename, group, A, groupB = NULL, B = NULL, block_size = NULL, paral = NULL, threads = NULL, mixblock_size = NULL, outgroup = NULL) {
    .Call('_BigDataStatMeth_bdCrossprod_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, A, groupB, B, block_size, paral, threads, mixblock_size, outgroup)
}

.blockmult_hdf5 <- function(filename, group, A, B, groupB = NULL, block_size = NULL, paral = NULL, threads = NULL, mixblock_size = NULL, outgroup = NULL, outdataset = NULL) {
    .Call('_BigDataStatMeth_blockmult_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, A, B, groupB, block_size, paral, threads, mixblock_size, outgroup, outdataset)
}

#' Block matrix multiplication with Delayed Array Object
#' 
#' This function performs a block matrix-matrix multiplication with numeric matrix or Delayed Arrays
#' 
#' @param filename string file name where dataset to normalize is stored
#' @param group string or Delayed Array Matrix
#' @param A, string with dataset name where matrix is stored
#' @param B, string with dataset name where matrix is stored
#' @param outgroup string with de group name under the matrix will be stored
#' @return list with filename and the group and dataset name under the results are stored
#' @examples
#' 
#' library(Matrix)
#' library(BigDataStatMeth)
#' 
#' k <- 1e3
#' set.seed(1)
#' x_sparse <- sparseMatrix(
#'     i = sample(x = k, size = k),
#'     j = sample(x = k, size = k),
#'     x = rnorm(n = k)
#' )
#' set.seed(2)
#' y_sparse <- sparseMatrix(
#'     i = sample(x = k, size = k),
#'     j = sample(x = k, size = k),
#'     x = rnorm(n = k)
#' )
#' 
#' if( isTRUE(file.exists('BasicMatVect.hdf5'))) {
#'      file.remove('BasicMatVect.hdf5')
#' }
#' bdCreate_hdf5_matrix_file("BasicMatVect.hdf5", as.matrix(x_sparse), "SPARSE", "x_sparse")
#' bdAdd_hdf5_matrix(as.matrix(y_sparse), "BasicMatVect.hdf5", "SPARSE", "y_sparse")
#' 
#' d <- bdblockmult_sparse_hdf5("BasicMatVect.hdf5", "SPARSE", "x_sparse", "y_sparse")
#' 
#' # Remove file (used as example)
#' if (file.exists("BasicMatVect.hdf5")) {
#'   # Delete file if it exist
#'   file.remove("BasicMatVect.hdf5")
#' }
#' 
#' @export
bdblockmult_sparse_hdf5 <- function(filename, group, A, B, outgroup = NULL) {
    .Call('_BigDataStatMeth_bdblockmult_sparse_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, A, B, outgroup)
}

#' Transposed Crossprod with hdf5 matrix
#' 
#' This function performs the transposed crossprod from a matrix inside and hdf5 data file
#' 
#' @param filename string file name where dataset to normalize is stored
#' @param group, string, group name where dataset A is stored
#' @param A string name inside HDF5 file
#' @param groupB, string, group name where dataset b is stored
#' @param B string, dataset name for matrix B inside HDF5 file
#' @param block_size (optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)
#' @param paral, (optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation
#' @param threads (optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available
#' @param mixblock_size (optional) only for debug pourpose
#' @param outgroup (optional) group name to store results from Crossprod inside hdf5 data file
#' @examples
#' 
#' library(BigDataStatMeth)
#' library(rhdf5)
#' 
#' matA <- matA <- matrix(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15), nrow = 3, byrow = TRUE)
#' matB <- matrix(c(15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,5,3,4,5,2,6,2,3,4,
#'                  42, 23, 23, 423,1,2), ncol = 5, byrow = TRUE)
#' 
#' bdCreate_hdf5_matrix_file("BasicMatVect.hdf5", matA, "INPUT", "matA")
#' bdAdd_hdf5_matrix( matB, "BasicMatVect.hdf5", "INPUT", "matB")
#' 
#' res <- bdtCrossprod_hdf5("BasicMatVect.hdf5", "INPUT",
#'                                         "matA", block_size = 2)
#' res2 <- bdtCrossprod_hdf5("BasicMatVect.hdf5", "INPUT", 
#'                                         "matA", "INPUT","matB", block_size = 2)
#' 
#' # Open file
#' h5fdelay = H5Fopen("BasicMatVect.hdf5")
#' 
#' res <- h5fdelay$OUTPUT$tCrossProd_matAxmatA
#' res2 <- h5fdelay$OUTPUT$tCrossProd_matAxmatB
#' 
#' all.equal(tcrossprod(matA), res)
#' all.equal(tcrossprod(matA, matB), res2)
#' 
#' # Close delayed.hdf5 file
#' H5Fclose(h5fdelay)
#' 
#' # Remove file (used as example)
#' if (file.exists("BasicMatVect.hdf5")) {
#'   # Delete file if it exist
#'   file.remove("BasicMatVect.hdf5")
#' }
#' 
#' @return If all process is ok, returns a list with : 
#' \itemize{
#'   \item{"filename"}{ File name where results are storesd }
#'   \item{"dataset"}{ route to results inside hdf5 data file }
#' }
#' 
#' 
#' 
#' @export
bdtCrossprod_hdf5 <- function(filename, group, A, groupB = NULL, B = NULL, block_size = NULL, paral = NULL, threads = NULL, mixblock_size = NULL, outgroup = NULL) {
    .Call('_BigDataStatMeth_bdtCrossprod_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, A, groupB, B, block_size, paral, threads, mixblock_size, outgroup)
}

#' Get minor allele frequency
#' 
#' This function normalize data scaling, centering or scaling and centering in a dataset stored in hdf5 file
#' 
#' @param filename string file name where dataset to normalize is stored
#' @param group string or Delayed Array Matrix
#' @param dataset string or Delayed Array Matrix
#' @param byrows, boolean, default TRUE. If true, the frequency is calculated by rows, else, if byrows= FALSE, frequency is calculated by columns
#' @param bparallel, boolean, Perform calculous in parallel?, by default TRUE.
#' @param wsize integer (default = 1000), file block size to read to perform normalization
#' @return Numeric vector with allele frequencies
#' @examples
#' 
#' library(BigDataStatMeth)
#' 
#' maf_cols = resc <- bdget_maf_hdf5("/Users/mailos/tmp/test/test.hdf5", 
#'                                           "test", "mat1", byrows = FALSE )
#' maf_rows = resc <- bdget_maf_hdf5("/Users/mailos/tmp/test/test.hdf5", 
#'                                           "test", "mat1", byrows = TRUE )
#' 
#' @export
bdget_maf_hdf5 <- function(filename, group, dataset, byrows = NULL, bparallel = NULL, wsize = NULL) {
    .Call('_BigDataStatMeth_bdget_maf_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, dataset, byrows, bparallel, wsize)
}

#' Converts text file to hdf5 data file
#' 
#' Converts text file to hdf5 data file
#' 
#' @param filename string file name with data to be imported
#' @param outputfile file name and path to store imported data
#' @param outGroup group name to store the dataset
#' @param outDataset dataset name to store the input file in hdf5
#' @param sep (optional), by default = "\\t". The field separator string. Values within each row of x are separated by this string.
#' @param header (optional) either a logical value indicating whether the column names of x are to be written along with x, or a character vector of column names to be written. See the section on ‘CSV files’ for the meaning of col.names = NA.
#' @param rownames (optional) either a logical value indicating whether the row names of x are to be written along with x, or a character vector of row names to be written.
#' @param overwrite (optional) either a logical value indicating whether the output file can be overwritten or not.
#' 
#' @return none value returned, data are stored in a dataset inside an hdf5 data file.
#' @export
bdImport_text_to_hdf5 <- function(filename, outputfile, outGroup, outDataset, sep = NULL, header = FALSE, rownames = FALSE, overwrite = FALSE) {
    invisible(.Call('_BigDataStatMeth_bdImport_text_to_hdf5', PACKAGE = 'BigDataStatMeth', filename, outputfile, outGroup, outDataset, sep, header, rownames, overwrite))
}

#' Impute SNPs in hdf5 omic dataset 
#'
#' Impute SNPs in hdf5 omic dataset 
#' 
#' @param filename, character array indicating the name of the file to create
#' @param group, character array indicating the input group where the data set to be imputed is. 
#' @param dataset, character array indicating the input dataset to be imputed
#' @param bycols, boolean by default = true, true indicates that the imputation will be done by columns, otherwise, the imputation will be done by rows
#' @param outgroup, optional character array indicating group where the data set will be saved after imputation if `outgroup` is NULL, output dataset is stored in the same input group. 
#' @param outdataset, optional character array indicating dataset to store the resulting data after imputation if `outdataset` is NULL, input dataset will be overwritten. 
#' @return Original hdf5 data file with imputed data
#' @export
bdImpute_snps_hdf5 <- function(filename, group, dataset, outgroup = NULL, outdataset = NULL, bycols = TRUE) {
    invisible(.Call('_BigDataStatMeth_bdImpute_snps_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, dataset, outgroup, outdataset, bycols))
}

#' Gets all dataset names inside a group
#'
#' Gets a list of all dataset names inside a group or all the datasets names 
#' starting with a prefix under a group
#' 
#' @param filename, character array indicating the name of the file to create
#' @param group, character array indicating the input group where the data sets are stored 
#' @param prefix, character array optional, indicates the prefix with which the dataset
#' names begin, if null, then the function returns all datasets inside the group
#' @return Full matrix with results from reduction
#' @export
bdgetDatasetsList_hdf5 <- function(filename, group, prefix = NULL) {
    .Call('_BigDataStatMeth_bdgetDatasetsList_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, prefix)
}

#' Normalize dataset in hdf5 file
#' 
#' This function normalize data scaling, centering or scaling and centering in a dataset stored in hdf5 file
#' 
#' @param filename string file name where dataset to normalize is stored
#' @param group string or Delayed Array Matrix
#' @param dataset string or Delayed Array Matrix
#' @param bcenter logical (default = TRUE) if TRUE, centering is done by subtracting the column means
#' @param bscale logical (default = TRUE) if TRUE, centering is done by subtracting the column means
#' @param wsize integer (default = 1000), file block size to read to perform normalization
#' @param force, boolean if true, previous results in same location inside hdf5 will be overwritten.
#' @return file with scaled, centered or scaled and centered dataset
#' @examples
#'   a = "See vignette"
#' @export
bdNormalize_hdf5 <- function(filename, group, dataset, bcenter = NULL, bscale = NULL, wsize = NULL, force = FALSE) {
    invisible(.Call('_BigDataStatMeth_bdNormalize_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, dataset, bcenter, bscale, wsize, force))
}

#' PCA Descomposition
#' 
#' Compute PCA
#' 
#' @param filename string, file name where dataset is stored 
#' @param group string group name  where dataset is stored in file
#' @param dataset string dataset name with data to perform PCA
#' @param bcenter logical value if true data is centered to zero
#' @param bscale logical value, if true data is scaled
#' @param k number of local SVDs to concatenate at each level, performance parameter 
#' @param q number of levels to compute SVD for PCA, performance parameter
#' @param force logical value, if true, the SVD is forced to be computed although the SVD exists
#' @param threads integer number of threads used to run PCA
#' @return original file with results in folder PCA/<datasetname>
#' @export
bdPCA_hdf5 <- function(filename, group, dataset, bcenter = FALSE, bscale = FALSE, k = 2L, q = 1L, force = FALSE, threads = NULL) {
    .Call('_BigDataStatMeth_bdPCA_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, dataset, bcenter, bscale, k, q, force, threads)
}

#' Reduce hdf5 dataset
#'
#' Reduce hdf5 datasets inside a group by rows or columns and store complete matrix inside hdf5 data file.
#' 
#' @param filename, character array indicating the name of the file to create
#' @param group, character array indicating the input group where the data sets are stored 
#' @param reducefunction, single character with function to apply, can be '+' or  '-' array indicating the input dataset to be imputed
#' @param outgroup, optional character array indicating group where the data set will be saved after imputation if `outgroup` is NULL, output dataset is stored in the same input group. 
#' @param outdataset, optional character array indicating dataset to store the resulting data after imputation if `outdataset` is NULL, input dataset will be overwritten. 
#' @param force, boolean if true, previous results in same location inside hdf5 will be overwritten.
#' @param remove, boolean if true, removes original matrices, by default bremove = false.
#' @return Full matrix with results from reduction
#' @export
bdReduce_matrix_hdf5 <- function(filename, group, reducefunction, outgroup = NULL, outdataset = NULL, force = FALSE, remove = FALSE) {
    .Call('_BigDataStatMeth_bdReduce_matrix_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, reducefunction, outgroup, outdataset, force, remove)
}

#' Remove SNPs in hdf5 omic dataset with low data
#'
#' Remove SNPs in hdf5 omic dataset with low data
#' 
#' @param filename, character array indicating the name of the file to create
#' @param group, character array indicating the input group where the data set to be imputed is. 
#' @param dataset, character array indicating the input dataset to be imputed
#' @param outgroup, character array indicating group where the data set will be saved after remove data with if `outgroup` is NULL, output dataset is stored in the same input group. 
#' @param outdataset, character array indicating dataset to store the resulting data after imputation if `outdataset` is NULL, input dataset will be overwritten. 
#' @param maf, by default maf = 0.05. Numeric indicating the percentage to be considered to remove SNPs, SNPS with higest MAF will be removed from data
#' @param bycols, boolean by default = true, if true, indicates that SNPs are in cols, if SNPincols = false indicates that SNPs are in rows.
#' @param blocksize, integer, block size dataset to read/write and calculate MAF, by default this operations is made in with 100 rows if byrows = true or 100 cols if byrows = false.
#' @return Original hdf5 data file with imputed data
#' @export
bdremove_maf_hdf5 <- function(filename, group, dataset, outgroup, outdataset, maf, bycols, blocksize) {
    .Call('_BigDataStatMeth_bdremove_maf_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, dataset, outgroup, outdataset, maf, bycols, blocksize)
}

#' Split hdf5 dataset
#'
#' Split hdf5 dataset by rows or columns and store splitted submatrices inside hdf5 file.
#' 
#' @param filename, character array indicating the name of the file to create
#' @param group, character array indicating the input group where the data set to be imputed is. 
#' @param dataset, character array indicating the input dataset to be imputed
#' @param outgroup, optional character array indicating group where the data set will be saved after imputation if `outgroup` is NULL, output dataset is stored in the same input group. 
#' @param outdataset, optional character array indicating dataset to store the resulting data after imputation if `outdataset` is NULL, input dataset will be overwritten. 
#' @param nblocks, integer number of blocks in which we want to split the data
#' @param blocksize, integer, number of elements in each block
#' @param bycols, boolean by default = true, true indicates that the imputation will be done by columns, otherwise, the imputation will be done by rows
#' @param force, boolean if true, previous results in same location inside hdf5 will be overwritten.
#' @return Original hdf5 data file with imputed data
#' @export
bdSplit_matrix_hdf5 <- function(filename, group, dataset, outgroup = NULL, outdataset = NULL, nblocks = NULL, blocksize = NULL, bycols = TRUE, force = FALSE) {
    invisible(.Call('_BigDataStatMeth_bdSplit_matrix_hdf5', PACKAGE = 'BigDataStatMeth', filename, group, dataset, outgroup, outdataset, nblocks, blocksize, bycols, force))
}

#' Normalize Delayed Array matrix
#' 
#' This function performs a numerical or Delayed Array matrix normalization
#' 
#' @param X numerical or Delayed Array Matrix
#' @param bcenter logical (default = TRUE) if TRUE, centering is done by subtracting the column means
#' @param bscale logical (default = TRUE) if TRUE, centering is done by subtracting the column means
#' @return numerical matrix
#' @examples
#' library(DelayedArray)
#' 
#' m <- 500
#' n <- 100 
#' x <- matrix(rnorm(m*n), nrow=m, ncol=n)
#' 
#' # with numeric matrix
#' bdNormalize_Data(x)
#' 
#' # with Delaeyd Array
#' Dx <- DelayedArray(x)
#' 
#' # Center and scale
#' bdNormalize_Data(Dx)
#' 
#' # Only scale
#' bdNormalize_Data(Dx, bcenter = FALSE)
#' 
#' # Only center
#' bdNormalize_Data(Dx, bscale = FALSE)
#' 
#' @export
bdNormalize_Data <- function(X, bcenter = NULL, bscale = NULL) {
    .Call('_BigDataStatMeth_bdNormalize_Data', PACKAGE = 'BigDataStatMeth', X, bcenter, bscale)
}

.bdMLR_MR <- function(X, y, blocks, threads = NULL) {
    .Call('_BigDataStatMeth_bdMLR_MR', PACKAGE = 'BigDataStatMeth', X, y, blocks, threads)
}

.bdCrossprod_generic <- function(A, B = NULL, transposed = NULL, block_size = NULL, paral = NULL, threads = NULL) {
    .Call('_BigDataStatMeth_bdCrossprod_generic', PACKAGE = 'BigDataStatMeth', A, B, transposed, block_size, paral, threads)
}

#' Matrix - Weighted vector Multiplication with numerical or DelayedArray data
#' 
#' This function performs a weighted product of a matrix(X) with a weighted diagonal matrix (w)
#' 
#' @param X numerical or Delayed Array matrix
#' @param w vector with weights
#' @param op string indicating if operation 'XtwX' and 'XwXt' for weighted cross product (Matrix - Vector - Matrix) or 'Xw' and 'wX' for weighted product (Matrix - Vector)
#' @return numerical matrix 
#' @examples
#' 
#' library(DelayedArray)
#' 
#' n <- 100
#' p <- 60
#' 
#' X <- matrix(rnorm(n*p), nrow=n, ncol=p)
#' 
#' u <- runif(n)
#' w <- u * (1 - u)
#' ans <- bdwproduct(X, w,"xtwx")
#' 
#' # with Delayed Array
#' 
#' DX <- DelayedArray(X)
#' 
#' ans <- bdwproduct(DX, w,"xtwx")
#' 
#' @export
bdwproduct <- function(X, w, op) {
    .Call('_BigDataStatMeth_bdwproduct', PACKAGE = 'BigDataStatMeth', X, w, op)
}

#' Matrix - Weighted Scalar Multiplication with numerical or DelayedArray data
#' 
#' This function performs a weighted product of a matrix(X) with a weighted diagonal matrix (w)
#' 
#' @param A numerical or Delayed Array matrix
#' @param w scalar, weight
#' @param op string indicating if operation  "Xw" or "wX"
#' @return numerical matrix 
#' @examples
#' 
#' library(DelayedArray)
#' 
#' n <- 100
#' p <- 60
#' 
#' X <- matrix(rnorm(n*p), nrow=n, ncol=p)
#' w <- 0.75
#' 
#' bdScalarwproduct(X, w,"Xw")
#' bdScalarwproduct(X, w,"wX")
#' 
#' # with Delayed Array
#' 
#' DX <- DelayedArray(X)
#' 
#' bdScalarwproduct(DX, w,"Xw")
#' bdScalarwproduct(DX, w,"wX")
#' 
#' @export
bdScalarwproduct <- function(A, w, op) {
    .Call('_BigDataStatMeth_bdScalarwproduct', PACKAGE = 'BigDataStatMeth', A, w, op)
}

#' Block matrix multiplication with Delayed Array Object
#' 
#' This function performs a block matrix-matrix multiplication with numeric matrix or Delayed Arrays
#' 
#' @param A a sparse double matrix.
#' @param B a sparse double matrix.
#' @param paral, (optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation
#' @param threads (optional) only if paral = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available
#' @return Sparse matrix with results
#' @examples
#' 
#' library(Matrix)
#' library(BigDataStatMeth)
#' 
#' k <- 1e3
#' set.seed(1)
#' x_sparse <- sparseMatrix(
#'     i = sample(x = k, size = k),
#'     j = sample(x = k, size = k),
#'     x = rnorm(n = k)
#' )
#' set.seed(2)
#' y_sparse <- sparseMatrix(
#'     i = sample(x = k, size = k),
#'     j = sample(x = k, size = k),
#'     x = rnorm(n = k)
#' )
#' 
#' d <- bdblockmult_sparse(x_sparse, y_sparse)
#' 
#' @export
bdblockmult_sparse <- function(A, B, paral = NULL, threads = NULL) {
    .Call('_BigDataStatMeth_bdblockmult_sparse', PACKAGE = 'BigDataStatMeth', A, B, paral, threads)
}

#' Block matrix multiplication with Delayed Array Object
#' 
#' This function performs a block matrix-matrix multiplication with numeric matrix or Delayed Arrays
#' 
#' @param a a double matrix.
#' @param b a double matrix.
#' @param block_size (optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)
#' @param paral, (optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation
#' @param threads (optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available
#' @param bigmatrix (optiona, default = 5000) maximum number of rows or columns to consider as big matrix and work with
#' hdf5 files, by default a matrix with more than 5000 rows or files is considered big matrix and computation is made in disk 
#' @param mixblock_size (optiona, default = 128), only if we are working with big matrix and parallel computation = true. 
#' Block size for mixed computation in big matrix parallel. Size of the block to be used to perform parallelized memory 
#' memory of the block read from the disk being processed.
#' @param outfile (optional) file name to work with hdf5 if we are working with big matrix in disk.
#' @param onmemory (optional) if onmemory = TRUE the multiplication is forced to execute in memory
#' @return A List with : 
#' \itemize{
#'   \item{"matrix"}{ Result matrix if execution has been performed in memory}
#'   \item{"filename"}{ HDF5 filename if execution has been performed in disk, HDF5 file contains : 
#'     \itemize{
#'       \item{"INPUT"}{hdf5 group with input matrix A and B}
#'       \item{"OUTPUT"}{hdf5 group with output matrix C}
#'     }with input and output matrix.
#'   }
#' }
#' @examples
#' 
#' library(DelayedArray)
#' 
#' # with numeric matrix
#' m <- 500
#' k <- 1500
#' n <- 400
#' A <- matrix(rnorm(n*k), nrow=n, ncol=k)
#' B <- matrix(rnorm(n*k), nrow=k, ncol=n)
#' 
#' C <- blockmult(A,B,128, TRUE)
#' 
#' # with Delaeyd Array
#' AD <- DelayedArray(A)
#' BD <- DelayedArray(B)
#' 
#' CD <- blockmult(AD,BD,128, TRUE)
#' 
#' @export
blockmult <- function(a, b, block_size = NULL, paral = NULL, threads = NULL, bigmatrix = NULL, mixblock_size = NULL, outfile = NULL, onmemory = NULL) {
    .Call('_BigDataStatMeth_blockmult', PACKAGE = 'BigDataStatMeth', a, b, block_size, paral, threads, bigmatrix, mixblock_size, outfile, onmemory)
}

CholFactor <- function(a) {
    .Call('_BigDataStatMeth_CholFactor', PACKAGE = 'BigDataStatMeth', a)
}

CholSolve <- function(a, b) {
    .Call('_BigDataStatMeth_CholSolve', PACKAGE = 'BigDataStatMeth', a, b)
}

inversechol_par <- function(a, threads = NULL) {
    .Call('_BigDataStatMeth_inversechol_par', PACKAGE = 'BigDataStatMeth', a, threads)
}

parxwxt <- function(X, W) {
    .Call('_BigDataStatMeth_parxwxt', PACKAGE = 'BigDataStatMeth', X, W)
}

parxtwx <- function(X, W) {
    .Call('_BigDataStatMeth_parxtwx', PACKAGE = 'BigDataStatMeth', X, W)
}

parXy <- function(X, Y) {
    .Call('_BigDataStatMeth_parXy', PACKAGE = 'BigDataStatMeth', X, Y)
}

#' Pseudo-Inverse
#' 
#' Compute the pseudo-inverse of a singular matrix
#' 
#' @param X Singular matrix (m x n)
#' @return Pseudo-inverse matrix of A
#' @export
bdpseudoinv <- function(X) {
    .Call('_BigDataStatMeth_bdpseudoinv', PACKAGE = 'BigDataStatMeth', X)
}

#' QR Decomposition 
#' 
#' This function compute QR decomposition (also called a QR factorization) 
#' of a matrix \code{A} into a product \code{A = QR} of an 
#' orthogonal matrix Q and an upper triangular matrix R.
#' 
#' @param X a real square matrix 
#' @param thin boolean thin, if thin = true returns Q thin  decomposition else returns Q full decomposition, default thin = false
#' @return List with orthogonal matrix \code{Q}  and upper triangular matrix \code{R}
#' @export
bdQR <- function(X, thin = NULL) {
    .Call('_BigDataStatMeth_bdQR', PACKAGE = 'BigDataStatMeth', X, thin)
}

#' Solves matrix equations : A*X = B
#' 
#' 
#' 
#' @param R numerical or Delayed Array matrix. 
#' @param Z numerical or Delayed Array matrix.
#' @param threads integer with number of threads to use with parallelized execution
#' @return X numerical matrix. 
#' @examples
#'  a <- "Unused function"
#' @export
bddtrsm <- function(R, Z, threads = NULL) {
    .Call('_BigDataStatMeth_bddtrsm', PACKAGE = 'BigDataStatMeth', R, Z, threads)
}

#' Create hdf5 data file and write data to it
#'
#' Creates a hdf5 file with numerical data matrix,
#' 
#' @param filename, character array indicating the name of the file to create
#' @param object numerical data matrix
#' @param group, character array indicating folder name to put the matrix in hdf5 file
#' @param dataset, character array indicating the dataset name to store the matix data
#' @param transp boolean, if trans=true matrix is stored transposed in hdf5 file
#' @param force, optional boolean if true and file exists, removes old file and creates a new file with de dataset data.
#' @return none
#' @export
bdCreate_hdf5_matrix_file <- function(filename, object, group = NULL, dataset = NULL, transp = NULL, force = NULL) {
    invisible(.Call('_BigDataStatMeth_bdCreate_hdf5_matrix_file', PACKAGE = 'BigDataStatMeth', filename, object, group, dataset, transp, force))
}

#' Write matrix to existing hdf5 file
#'
#' Creates a hdf5 file with numerical data matrix,
#' 
#' @param object numerical data matrix
#' @param filename, character array indicating the name of the file to create
#' @param group, character array indicating folder or group name to put the matrix in hdf5 file
#' @param dataset, character array indicating the dataset name that contains the matix data
#' @param transp, boolean if true, data is manipulated in transposed form
#' @param force, optional boolean if true and file exists, removes old file and creates a new file with de dataset data.
#' @return none
#' @export
bdAdd_hdf5_matrix <- function(object, filename, group, dataset, transp = NULL, force = FALSE) {
    invisible(.Call('_BigDataStatMeth_bdAdd_hdf5_matrix', PACKAGE = 'BigDataStatMeth', object, filename, group, dataset, transp, force))
}

#' Remove element group or dataset from  hdf5 file
#'
#' Remove group or dataset from  hdf5 file
#' 
#' @param filename, character array indicating the name of the file to create
#' @param element path to element, character array indicating the complete route to the element to be removed (folder or dataset). 
#' @return none
#' @export
bdRemove_hdf5_element <- function(filename, element) {
    invisible(.Call('_BigDataStatMeth_bdRemove_hdf5_element', PACKAGE = 'BigDataStatMeth', filename, element))
}

#' Get dataset dimensions
#'
#' get dataset dimensions
#' 
#' @param filename, character array indicating the name of the file to create
#' @param element path to element, character array indicating the complete route to the element to query size (folder or dataset). 
#' @return none
#' @export
bdgetDim_hdf5 <- function(filename, element) {
    .Call('_BigDataStatMeth_bdgetDim_hdf5', PACKAGE = 'BigDataStatMeth', filename, element)
}

#' Solve matrix equations
#' 
#' This function solve matrix equations 
#'  \code{A * X = B } 
#' where A is an N-by-N matrix and X and B are N-by-NRHS matrices.
#' 
#' @param A numerical or Delayed Array matrix. 
#' @param B numerical or Delayed Array matrix.
#' @return X numerical matrix. 
#' @examples
#' 
#' library(DelayedArray)
#' library(BigDataStatMeth)
#' 
#' n <- 500
#' m <- 500
#' 
#' # R Object
#' 
#' A <- matrix(runif(n*m), nrow = n, ncol = m)
#' B <- matrix(runif(n), nrow = n)
#' AS <- A%*%t(A)
#'       
#' DA <- DelayedArray(A)
#' DB <- DelayedArray(B)
#' ASD <- DelayedArray(AS)
#'   
#' X <- bdSolve(A, B)
#' XR <- solve(A,B)
#' XRD <- bdSolve(DA,DB)
#'       
#' all.equal(X, XR, check.attributes=FALSE)
#' all.equal(XR, XRD, check.attributes=FALSE)
#'   
#' @export
bdSolve <- function(A, B) {
    .Call('_BigDataStatMeth_bdSolve', PACKAGE = 'BigDataStatMeth', A, B)
}

#' Inverse Cholesky of Delayed Array
#' 
#' This function get the inverse of a numerical or Delayed Array matrix. If x is hermitian and positive-definite matrix then gets the inverse using Cholesky decomposition
#' 
#' 
#' @param X numerical or Delayed Array matrix. If x is Hermitian and positive-definite performs
#' @return inverse matrix of d 
#' @examples
#' 
#' library(DelayedArray)
#' 
#' A <- matrix(c(3,4,3,4,8,6,3,6,9), byrow = TRUE, ncol = 3)
#' bdInvCholesky(A)
#' 
#' # with Delayed Array
#' DA <- DelayedArray(A)
#' bdInvCholesky(DA)
#' 
#' @export
bdInvCholesky <- function(X) {
    .Call('_BigDataStatMeth_bdInvCholesky', PACKAGE = 'BigDataStatMeth', X)
}

#' k first SVD components for DelayedArray 
#' 
#' This function gets k first components from svd decomposition of numerical or Delayed Array 
#' 
#' @param X numerical or Delayed Array matrix
#' @param k number of eigen values , this should satisfy k = min(n, m) - 1
#' @param nev (optional, default nev = n-1) Number of eigenvalues requested. This should satisfy 1<= nev <= n, where n is the size of matrix. 
#' @param bcenter (optional, defalut = TRUE) . If center is TRUE then centering is done by subtracting the column means (omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.
#' @param bscale (optional, defalut = TRUE) .  If scale is TRUE then scaling is done by dividing the (centered) columns of x by their standard deviations if center is TRUE, and the root mean square otherwise. If scale is FALSE, no scaling is done.
#' @return u eigenvectors of AA^t, mxn and column orthogonal matrix
#' @return v eigenvectors of A^tA, nxn orthogonal matrix
#' @return d singular values, nxn diagonal matrix (non-negative real values)
#' @examples
#' 
#' library(DelayedArray)
#' 
#' n <- 500
#' A <- matrix(rnorm(n*n), nrow=n, ncol=n)
#' AD <- DelayedArray(A)
#' 
#' # svd without normalization
#' decsvd <- bdSVD( A, bscale = FALSE, bcenter = FALSE ) # No matrix normalization
#' decsvd$d
#' decsvd$u
#' 
#' # svd with normalization
#' decvsd <- bdSVD( A, bscale = TRUE, bcenter = TRUE) # Matrix normalization
#' 
#' decsvd$d
#' decsvd$u
#' 
#' # svd with scaled matrix (sd)
#' decvsd <- bdSVD( A, bscale = TRUE, bcenter = FALSE) # Scaled matrix
#' 
#' decsvd$d
#' decsvd$u
#' # svd with centered matrix (sd)
#' decvsd <- bdSVD( A, bscale = FALSE, bcenter = TRUE) # Centered matrix
#' decsvd$d
#' decsvd$u
#' 
#' @export
bdSVD <- function(X, k = 0L, nev = 0L, bcenter = TRUE, bscale = TRUE) {
    .Call('_BigDataStatMeth_bdSVD', PACKAGE = 'BigDataStatMeth', X, k, nev, bcenter, bscale)
}

#' Block SVD decomposition for hdf5 files using an incremental algorithm.
#'
#' Singular values and left singular vectors of a real nxp matrix 
#' @title Block SVD decomposition using an incremental algorithm.
#' @param file a real nxp matrix in hdf5 file
#' @param group group in hdf5 data file where dataset is located
#' @param dataset matrix dataset with data to perform SVD
#' @param k number of local SVDs to concatenate at each level 
#' @param q number of levels
#' @param bcenter (optional, defalut = TRUE) . If center is TRUE then centering is done by subtracting the column means (omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.
#' @param bscale (optional, defalut = TRUE) .  If scale is TRUE then scaling is done by dividing the (centered) columns of x by their standard deviations if center is TRUE, and the root mean square otherwise. If scale is FALSE, no scaling is done.
#' @param threads (optional) only used in some operations inside function. If threads is null then threads =  maximum number of threads available - 1.
#' @return a list of three components with the singular values and left and right singular vectors of the matrix
#' @return A List with : 
#' \itemize{
#'   \item{"u"}{ eigenvectors of AA^t, mxn and column orthogonal matrix }
#'   \item{"v"}{ eigenvectors of A^tA, nxn orthogonal matrix }
#'   \item{"v"}{ singular values, nxn diagonal matrix (non-negative real values) }
#' }
#' @export
bdSVD_hdf5 <- function(file, group = NULL, dataset = NULL, k = 2L, q = 1L, bcenter = TRUE, bscale = TRUE, threads = NULL) {
    .Call('_BigDataStatMeth_bdSVD_hdf5', PACKAGE = 'BigDataStatMeth', file, group, dataset, k, q, bcenter, bscale, threads)
}

#' Complete SVD with Lapack Functions for DelayedArray and RObjects
#' 
#' This function performs a complete svd decomposition of numerical matrix or Delayed Array with 
#' 
#' @param X numerical or Delayed Array matrix
#' @param bcenter (optional, defalut = TRUE) . If center is TRUE then centering is done by subtracting the column means (omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.
#' @param bscale (optional, defalut = TRUE) .  If scale is TRUE then scaling is done by dividing the (centered) columns of x by their standard deviations if center is TRUE, and the root mean square otherwise. If scale is FALSE, no scaling is done.
#' @param complete (optional, defalut = FALSE) . If complete is TRUE svd function returns complete u and v
#' @return u eigenvectors of AA^t, mxn and column orthogonal matrix
#' @return v eigenvectors of A^tA, nxn orthogonal matrix
#' @return d singular values, nxn diagonal matrix (non-negative real values)
#' @examples
#' 
#' library(BigDataStatMeth)
#' n <- 500
#' A <- matrix(rnorm(n*n), nrow=n, ncol=n)
#' 
#' # svd without normalization
#' decsvd <- bdSVD_lapack( A, bscale = FALSE, bcenter = FALSE ) # No matrix normalization
#' decsvd$d
#' decsvd$u
#' 
#' # svd with normalization
#' decvsd <- bdSVD_lapack( A, bscale = TRUE, bcenter = TRUE) # Matrix normalization
#' decvsd <- bdSVD_lapack( A ) # Matrix normalization too
#' decsvd$d
#' decsvd$u
#' 
#' # svd with scaled matrix (sd)
#' decvsd <- bdSVD_lapack( A, bscale = TRUE, bcenter = FALSE) # Scaled matrix
#' 
#' @export
bdSVD_lapack <- function(X, bcenter = TRUE, bscale = TRUE, complete = FALSE) {
    .Call('_BigDataStatMeth_bdSVD_lapack', PACKAGE = 'BigDataStatMeth', X, bcenter, bscale, complete)
}

#' Block matrix multiplication with Delayed Array Object
#' 
#' This function performs a Crossproduct with weigths matrix A%*%W%*%t(A) multiplication with numeric matrix or Delayed Arrays
#' 
#' @param A a double matrix.
#' @param W a Weighted matrix
#' @param block_size (optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)
#' @param paral, (optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation
#' @param threads (optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available
#' @return Matrix with A%*%W%*%t(A) product 
#' @examples
#' 
#' library(DelayedArray)
#' 
#' # with numeric matrix
#' m <- 500
#' k <- 1500
#' n <- 400
#' A <- matrix(rnorm(n*k), nrow=n, ncol=k)
#' B <- matrix(rnorm(n*k), nrow=k, ncol=n)
#' 
#' 
#' # with Delaeyd Array
#' AD <- DelayedArray(A)
#' BD <- DelayedArray(B)
#' 
#' # Serial execution
#' Serie<- bdtCrossprod_Weighted(A, B, paral = FALSE)
#' 
#' # Parallel execution with 2 threads and blocks 256x256
#' Par_2cor <- bdtCrossprod_Weighted(A, B, paral = TRUE, block_size = 256, threads = 2)
#' @export
bdtCrossprod_Weighted <- function(A, W, block_size = NULL, paral = NULL, threads = NULL) {
    .Call('_BigDataStatMeth_bdtCrossprod_Weighted', PACKAGE = 'BigDataStatMeth', A, W, block_size, paral, threads)
}

#' Sumarize vector
#' 
#' This function sumarize the elements of a vector
#' 
#' @param x numerical vector
#' @examples
#' library(BigDataStatMeth)
#' 
#' n <- 100 
#' x <- rnorm(n)
#' 
#' # with numeric matrix
#' res <- bdparallelVectorSum(x)
#' 
#' @return none value returned, data are stored in a dataset inside an hdf5 data file.
#' 
#' @export
bdparallelVectorSum <- function(x) {
    .Call('_BigDataStatMeth_bdparallelVectorSum', PACKAGE = 'BigDataStatMeth', x)
}

#' Pow vector
#' 
#' Gets pow2 vector
#' 
#' @param x numerical vector
#' @examples
#' library(BigDataStatMeth)
#' 
#' n <- 100 
#' x <- rnorm(n)
#' 
#' # with numeric matrix
#' res <- bdparallelpow2(x)
#' 
#' @return Numeric Vector
#' 
#' @export
bdparallelpow2 <- function(x) {
    .Call('_BigDataStatMeth_bdparallelpow2', PACKAGE = 'BigDataStatMeth', x)
}

