% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdremove_maf_hdf5}
\alias{bdremove_maf_hdf5}
\title{Remove SNPs in hdf5 omic dataset with low data}
\usage{
bdremove_maf_hdf5(
  filename,
  group,
  dataset,
  outgroup,
  outdataset,
  maf,
  bycols,
  blocksize
)
}
\arguments{
\item{filename, }{character array indicating the name of the file to create}

\item{group, }{character array indicating the input group where the data set to be imputed is.}

\item{dataset, }{character array indicating the input dataset to be imputed}

\item{outgroup, }{character array indicating group where the data set will be saved after remove data with if `outgroup` is NULL, output dataset is stored in the same input group.}

\item{outdataset, }{character array indicating dataset to store the resulting data after imputation if `outdataset` is NULL, input dataset will be overwritten.}

\item{maf, }{by default maf = 0.05. Numeric indicating the percentage to be considered to remove SNPs, SNPS with higest MAF will be removed from data}

\item{bycols, }{boolean by default = true, if true, indicates that SNPs are in cols, if SNPincols = false indicates that SNPs are in rows.}

\item{blocksize, }{integer, block size dataset to read/write and calculate MAF, by default this operations is made in with 100 rows if byrows = true or 100 cols if byrows = false.}
}
\value{
Original hdf5 data file with imputed data
}
\description{
Remove SNPs in hdf5 omic dataset with low data
}
