% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamplot_scopus.R
\name{beamplot_scopus}
\alias{beamplot_scopus}
\title{Create a beamplot using raw citations from a Scopus download}
\usage{
beamplot_scopus(scopus_file, do_weight = FALSE, ...)
}
\arguments{
\item{scopus_file}{is the file name of the downloaded Scopus export in the format CSV/Excel.}

\item{do_weight}{is a boolean to spcify if citation counts should be weighted with their age. The older the publication, the smaller the weight. The weight depends on on the difference between the year until that citations are counted (i.e., the current calendar year in the case of Scopus downloads) and the publication year. A weighting factor of 1 is used for a difference of 0, 1/2 for a difference of 1, ..., and 1/11 for differences of ten or more.}

\item{...}{further parameters passed to stripchart.}
}
\description{
Create a beamplot using raw citations from a Scopus download. Use the CSV/Excel format
and provide the downloaded file name.
A simple weighting of citation counts is also available for comparison of older with newer publications.
}
\details{
beamplot_scopus(scopus_file="Scopus.csv", do_weight=boolean)
Only the argument scopus_file is mandatory. The argument do_weight is optional and FALSE by default.

Literature:

- Haunschild, R., Bornmann, L., & Adams, J. (2019). R package for producing beamplots as a preferred alternative to the h index when assessing single researchers (based on downloads from Web of Science), Scientometrics, DOI 10.1007/s11192-019-03147-3, preprint: https://arxiv.org/abs/1905.09095
}
\examples{

\dontrun{beamplot_scopus("Scopus.csv")}

}
