% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/othercnstr.R, R/printmethods.R, R/summary.R
\name{scorespace}
\alias{scorespace}
\alias{print.scorespace}
\alias{summary.scorespace}
\title{Prints 'scorespace' object}
\usage{
scorespace(
  scorepar,
  alpha = 0.05,
  hardlimit = 14,
  plus1 = TRUE,
  cpdag = TRUE,
  startspace = NULL,
  blacklist = NULL,
  verbose = FALSE
)

\method{print}{scorespace}(x, ...)

\method{summary}{scorespace}(object, ...)
}
\arguments{
\item{scorepar}{an object of class \code{scoreparameters}, containing the data and score scorepareters, see constructor function \code{\link{scoreparameters}}}

\item{alpha}{numerical significance value in \code{\{0,1\}} for the conditional independence tests at the PC algorithm stage (by default \eqn{0.4} for \eqn{n<50}, \eqn{20/n} for \eqn{n>50})}

\item{hardlimit}{integer, limit on the size of parent sets in the search space; by default 14 when MAP=TRUE and 20 when MAP=FALSE}

\item{plus1}{logical, if TRUE (default) the search is performed on the extended search space}

\item{cpdag}{logical, if TRUE the CPDAG returned by the PC algorithm will be used as the search
space, if FALSE (default) the full undirected skeleton will be used as the search space}

\item{startspace}{(optional) a square matrix, of dimensions equal to the number of nodes, which defines the search space for the order MCMC in the form of an adjacency matrix. If NULL, the skeleton obtained from the PC-algorithm will be used. If \code{startspace[i,j]} equals to 1 (0) it means that the edge from node \code{i} to node \code{j} is included (excluded) from the search space. To include an edge in both directions, both \code{startspace[i,j]} and \code{startspace[j,i]} should be 1.}

\item{blacklist}{(optional) a square matrix, of dimensions equal to the number of nodes, which defines edges to exclude from the search space. If \code{blacklist[i,j]} equals to 1 it means that the edge from node \code{i} to node \code{j} is excluded from the search space.}

\item{verbose}{logical, if TRUE messages about the algorithm's progress will be printed, FALSE by default}

\item{x}{object of class 'scorespace'}

\item{...}{ignored}

\item{object}{object of class 'scorespace'}
}
\value{
Object of class \code{scorespace}, a list of three objects: 'adjacency' matrix representiong the search space, 'blacklist' used to exclude edges from the search space and 'tables' containing score quantities for each node
needed to run MCMC schemes
}
\description{
Prints 'scorespace' object

Summary of object of class 'scorespace'
}
\examples{
#' #find a MAP DAG with search space defined by PC and plus1 neighbourhood
Bostonscore<-scoreparameters("bge",Boston)
Bostonspace<-scorespace(Bostonscore, 0.05, 14)
\dontrun{
orderfit<-orderMCMC(Bostonscore, scoretable=Bostonspace)
partitionfit<-orderMCMC(Bostonscore, scoretable=Bostonspace)
}
}
\references{
Friedman N and Koller D (2003). A Bayesian approach to structure discovery in bayesian networks. Machine Learning 50, 95-125.
}
\author{
Polina Suter, Jack Kuipers
}
