% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidencePP.R
\name{evidencePP}
\alias{evidencePP}
\title{Evidence estimation via power posteriors}
\usage{
evidencePP(
  formula,
  prior.mean = NULL,
  prior.sigma = NULL,
  aux.iters = 1000,
  n.aux.draws = 50,
  aux.thin = 50,
  ladder = 30,
  main.iters = 20000,
  burn.in = 5000,
  thin = 1,
  V.proposal = 1.5,
  seed = 1,
  temps = NULL,
  estimate = c("MLE", "CD"),
  ...
)
}
\arguments{
\item{formula}{formula; an \code{\link[ergm]{ergm}} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link[network]{network}} object
and <model terms> are \code{ergm-terms}.}

\item{prior.mean}{vector; mean vector of the multivariate Normal prior.
By default set to a vector of 0's.}

\item{prior.sigma}{square matrix; variance/covariance matrix for the multivariate Normal prior.
By default set to a diagonal matrix with every diagonal entry equal to 100.}

\item{aux.iters}{count; number of auxiliary iterations used for drawing the first network from the ERGM likelihood. See \code{\link[ergm]{control.simulate.formula}} and \code{\link[Bergm]{ergmAPL}}.}

\item{n.aux.draws}{count; number of auxiliary networks drawn from the ERGM likelihood. See \code{\link[ergm]{control.simulate.formula}} and \code{\link[Bergm]{ergmAPL}}.}

\item{aux.thin}{count; number of auxiliary iterations between network draws after the first network is drawn. See \code{\link[ergm]{control.simulate.formula}} and \code{\link[Bergm]{ergmAPL}}.}

\item{ladder}{count; length of temperature ladder (>=3). See \code{\link[Bergm]{ergmAPL}}.}

\item{main.iters}{count; number of MCMC iterations after burn-in for the adjusted pseudo-posterior estimation.}

\item{burn.in}{count; number of burn-in iterations at the beginning of an MCMC run for the adjusted pseudo-posterior estimation.}

\item{thin}{count; thinning interval used in the simulation for the adjusted pseudo-posterior estimation. The number of MCMC iterations must be divisible by this value.}

\item{V.proposal}{count; diagonal entry for the multivariate Normal proposal.
By default set to 1.5.}

\item{seed}{integer; seed for the random number generator. 
See \code{set.seed} and \code{\link[MCMCpack]{MCMCmetrop1R}}.}

\item{temps}{numeric vector; inverse temperature ladder, \eqn{t \in [0,1]}.}

\item{estimate}{If "MLE" (the default), then an approximate maximum likelihood estimator is returned. If "CD" , the Monte-Carlo contrastive divergence estimate is returned. See \code{\link[ergm]{ergm}}.}

\item{...}{additional arguments, to be passed to the ergm function. 
See \code{\link[ergm]{ergm}} and \code{\link[Bergm]{ergmAPL}}.}
}
\description{
Function to estimate the evidence (marginal likelihood) with Power posteriors, 
based on the adjusted pseudolikelihood function.
}
\examples{
\dontrun{
# Load the florentine marriage network:
data(florentine)

PPE <- evidencePP(flomarriage ~ edges + kstar(2),
                  aux.iters   = 500, 
                  noisy.nsim  = 50,   
                  aux.thin    = 50,   
                  main.iters  = 2000,
                  burn.in     = 100,
                  V.proposal  = 2.5)
                                   
# Posterior summaries:
summary(PPE)

# MCMC diagnostics plots:
plot(PPE)
  
# Log-evidence (marginal likelihood) estimate:             
PPE$log.evidence
}

}
\references{
Bouranis, L., Friel, N., & Maire, F. (2018). Bayesian model selection for exponential 
random graph models via adjusted pseudolikelihoods. 
Journal of Computational and Graphical Statistics, 27(3), 516-528. 
\url{https://arxiv.org/abs/1706.06344}
}
