% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChaoWrapper.R
\name{ChaoWrapper}
\alias{ChaoWrapper}
\title{Parallel estimation of species richness in a community using iChao}
\usage{
ChaoWrapper(
  data = NULL,
  datatype = "abundance",
  k = 10,
  conf = 0.95,
  mc.cores = 1
)
}
\arguments{
\item{data}{A data frame or tibble. A data frame containing "abundance"-type data per variable
(population, country, species...) in columns.}

\item{datatype}{Character. The type of input data, "abundance", "abundance_freq_count",
"incidence_freq", "incidence_freq_count" or "incidence_raw". So far only tested with "abundance"
data. Default = "abundace".}

\item{k}{Numeric. the cut-off point (default = 10), which separates species into "abundant" and "rare"
groups for abundance data for the estimator ACE; it separates species into "frequent" and
"infrequent" groups for incidence data for the estimator ICE.
Default = 10.}

\item{conf}{Numeric. A positive number equal to or less than 1 specifying the level of
confidence interval. Default = 0.95.}

\item{mc.cores}{Numeric. If > 1, the function will run in parallel
using mclapply using the number of cores specified. If = 1 then it will be run using a serial
loop. NOTE: Windows machines must use a value of 1 (see ?parallel::mclapply). Additionally,
be aware that each thread can use large chunks of memory.
Default = 1.}
}
\value{
Returns a list containing two tibbles. The first is a tibble that concatenates the outputs
from the basic data and rare species information in columns per input variable (column). The second is a tibble
that concatenates the various species richness estimates, with input variables in chunks of rows.
Additionally a console output will list the variables (columns) that lacked sufficient data
to be analysed.
}
\description{
ChaoSpecies: Estimation of species richness in a single community based on five types of data:
Type (1) abundance data (datatype="abundance"), Type (1A) abundance-frequency counts
(datatype="abundance_freq_count"), Type (2) incidence-frequency data
(datatype = "incidence_freq"), Type (2A) incidence-frequency counts
(datatype="incidence_freq_count"), and Type (2B) incidence-raw data (datatype="incidence_raw");
see SpadeR-package details for data input formats.
}
\examples{
\dontrun{
  # Read in some example data and use [BeeBDC::richnessPrepR()] to create the example input data
 #' data(beesCountrySubset)

estimateDataExample <- BeeBDC::richnessPrepR(
  data = beesCountrySubset,
  # Download the taxonomy
  taxonomyFile = BeeBDC::beesTaxonomy(),
  # Download the checklist
  checklistFile = BeeBDC::beesChecklist(),
  curveFunction = function(x) (228.7531 * x * x^-log(12.1593)),
  sampleSize = 10000,
  countryColumn = "country_suggested",
  limitGlobal = NULL,
  outPath = tempdir()
)

  # Transform the data for input
inputTestData <- estimateDataExample$site_speciesCounts \%>\%
  dplyr::select(scientificName, country_suggested, n) \%>\%
  tidyr::pivot_wider(names_from = country_suggested,
                     values_from = n,
                     values_fill = 0) \%>\%
  # Create the rownames
tibble::column_to_rownames("scientificName") \%>\%
  dplyr::tibble()

iChaoOut <- ChaoWrapper(
data = inputTestData,
datatype = "abundance",
k = 10,
conf = 0.95,
mc.cores = 1)
}
}
\seealso{
\code{\link[SpadeR:ChaoSpecies]{SpadeR::ChaoSpecies()}}
}
