% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPV_diagnostic_vs_screening.R
\name{PPV_diagnostic_vs_screening}
\alias{PPV_diagnostic_vs_screening}
\title{Plot PPV values for a diagnostic and a screening group}
\usage{
PPV_diagnostic_vs_screening(
  max_FP = 10,
  Sensitivity = 100,
  prevalence_screening_group = 100,
  prevalence_diagnostic_group = 2,
  labels_prevalence = c("Screening", "Diagnostic"),
  folder = ""
)
}
\arguments{
\item{max_FP}{False positive rate (1-Specificity) [0-100].}

\item{Sensitivity}{Sensitivity of the test [0-100].}

\item{prevalence_screening_group}{Prevalence of the screening group, 1 out of x [1-Inf].}

\item{prevalence_diagnostic_group}{Prevalence of the diagnostic group, 1 out of x [1-Inf].}

\item{labels_prevalence}{Labels to use for both groups.}

\item{folder}{Where to save the plot (the filename would be automatically created using the plot parameters)}
}
\value{
Shows a plot or, if given a folder argument, saves a .png version of the plot
}
\description{
Plot PPV associated to different levels of FP and a specific Sensitivity, for two different Prevalence groups.
}
\examples{

# Example 1
PPV_diagnostic_vs_screening(max_FP = 10, Sensitivity = 100, 
                            prevalence_screening_group = 1500, 
                            prevalence_diagnostic_group = 3)

# Example 2. QWith custom labels
PPV_diagnostic_vs_screening(max_FP = 10, Sensitivity = 100, 
                            prevalence_screening_group = 1667, 
                            prevalence_diagnostic_group = 44, 
                           labels_prevalence = c("20 y.o.", "50 y.o."))
}
