% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibetabinomialpost.R
\name{ibetabinomial.post}
\alias{ibetabinomial.post}
\title{ibetabinomial.post}
\usage{
ibetabinomial.post(n, y, pi.star = 0.5, pess = 2)
}
\arguments{
\item{n}{A vector of treated patients for each arm (The first element is for control)}

\item{y}{A vector of treated patient outcomes for each arm (The first element is for control)}

\item{pi.star}{The prior response probability. The default is 0.5}

\item{pess}{The effective sample size of beta prior. The default is 2}
}
\value{
A vector posterior probability of each active treatment arm better than control
}
\description{
This function calculates the posterior probability of each active treatment arm better than control using betabinomial model
}
\examples{
n <- c(20,20,20,20)
y <- c(12,12,12,6)
ibetabinomial.post(n, y, pi.star = 0.5, pess = 2)
#[1] 0.5000000 0.5000000 0.0308018
}
\author{
Ziyan Wang
}
