% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Demo_CutoffScreening.R
\name{demo_Cutoffscreening}
\alias{demo_Cutoffscreening}
\title{demo_Cutoffscreening}
\usage{
demo_Cutoffscreening(
  ntrials = 1000,
  trial.fun = simulatetrial,
  grid.inf = list(start = c(0.9, 0.95, 1), extendlength = 15),
  input.info = list(response.probs = c(0.4, 0.4), ns = c(30, 60, 90, 120, 150), max.ar =
    0.75, rand.algo = "Urn", max.deviation = 3, model.inf = list(model = "tlr", ibb.inf =
    list(pi.star = 0.5, pess = 2, betabinomialmodel = ibetabinomial.post), tlr.inf =
    list(beta0_prior_mu = 0, beta1_prior_mu = 0, beta0_prior_sigma = 2.5,
    beta1_prior_sigma = 2.5, beta0_df = 7, beta1_df = 7, reg.inf = "main", variable.inf =
    "Fixeffect")), Stop.type = "Early-Pocock", Boundary.type = "Symmetric", Random.inf =
    list(Fixratio = FALSE, 
     Fixratiocontrol = NA, BARmethod = "Thall",
    Thall.tuning.inf = list(tuningparameter = "Fixed", fixvalue = 1)), trend.inf =
    list(trend.type = "step", trend.effect = c(0, 0), trend_add_or_multip = "mult")),
  cl = 2
)
}
\arguments{
\item{ntrials}{A numeric variable indicating how many trial replicates you want to run}

\item{trial.fun}{The function of trial simulation, related to MainFunction.R}

\item{grid.inf}{A list of grid information to create start grid and extend grid for cutoff screening.}

\item{input.info}{A list of input information including all information required for trial simulation.}

\item{cl}{A numeric variable indicating how many cores you want to use in parallel programming.}
}
\value{
A vector of recommended cutoff. The final value is the latest recommended value. A plot for all tested cutoff and error rate
}
\description{
This function does a cutoff screening for trial simulation.
}
\examples{
\donttest{demo_Cutoffscreening(ntrials = 2, cl = 2,
    grid.inf = list(start = c(0.9, 0.95, 1), extendlength = 2))}
}
\author{
Ziyan Wang
}
