% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argMax.R
\name{argMax}
\alias{argMax}
\title{Arg Max: Extract a subscript corresponding component is a max}
\usage{
argMax(numeric_vector, verbose = FALSE)
}
\arguments{
\item{numeric_vector}{A vector, each component is a real number (an object of class numeric).}

\item{verbose}{A logical, if TRUE, then verbose summary is printed in R or R studio console.}
}
\value{
A non-negative integer, indicating a subscript, corresponding component is the maximum component.
}
\description{
The non-negative valued function of a vector, which returns
a subscript whose component is the maximal component of the vector.

 If the maximal component is not unique, then the lowest is chosen


Namely, for an arbitrary  \code{vector},

\code{argMax(vector) = i}

 if and only if \code{i} is the smallest number such that

   \code{vector[i] >= vector[j]} for all \code{j}.
}
\details{
This function is very fundamental and so,,,
Is there a same function in the package \pkg{base}?
}
\examples{

     argMax(c(0,0,0,0,0,0,0,0,0,0))
     argMax(c(11,0,0,0,0,0,0,0,0,0))
     argMax(c(0,22,0,0,0,0,0,0,0,0))
     argMax(c(0,0,33,0,0,0,0,0,0,0))
     argMax(c(0,0,0,44,0,0,0,0,0,0))
     argMax(c(0,0,0,0,55,0,0,0,0,0))
     argMax(c(0,0,0,0,0,66,0,0,0,0))
     argMax(c(0,0,0,0,0,0,77,0,0,0))
     argMax(c(0,0,0,0,0,0,0,88,0,0))
     argMax(c(0,0,0,0,0,0,0,0,99,0))

     # If the maximal component is not unique, then the lowest is chosen
     argMax(c(0,0,0,44,0,0,44,0,0,0))


     argMax(c(NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN))
     argMax(c(11,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN))
     argMax(c(NaN,22,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN))
     argMax(c(NaN,NaN,33,NaN,NaN,NaN,NaN,NaN,NaN,NaN))
     argMax(c(NaN,NaN,NaN,44,NaN,NaN,NaN,NaN,NaN,NaN))
     argMax(c(NaN,NaN,NaN,NaN,55,NaN,NaN,NaN,NaN,NaN))
     argMax(c(NaN,NaN,NaN,NaN,NaN,66,NaN,NaN,NaN,NaN))
     argMax(c(NaN,NaN,NaN,NaN,NaN,NaN,77,NaN,NaN,NaN))
     argMax(c(NaN,NaN,NaN,NaN,NaN,NaN,NaN,88,NaN,NaN))
     argMax(c(NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,99,NaN))
     argMax(c(NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,100))


     argMax(c(NaN,NaN,NaN,22,NaN,55,NaN,NaN,NaN,NaN))
     argMax(c(NaN,44,NaN,11,NaN,NaN,NaN,NaN,NaN,NaN))
     argMax(c(NaN,NaN,33, 33, 33, 33,NaN,NaN,NaN,NaN))

}
