% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Phi__and__Phi_inv.R
\name{Phi}
\alias{Phi}
\title{The Cumulative distribution function \eqn{\Phi(x)}
 of the Standard Gaussian, namely, mean = 0 and variance =1.}
\usage{
Phi(x)
}
\arguments{
\item{x}{A real. To be passed to
the function \code{stats::pnorm()}}
}
\value{
\eqn{\Phi(x) := \int _{-\infty}^x Gaussian(z|0,1)dz   }
}
\description{
\deqn{\Phi(x):= \int_{-\infty}^x \frac{1}{\sqrt{2\pi}} e^{\frac{-x^2}{2}}   }
}
\examples{
#========================================================================================
#            1)             validation of this function
#========================================================================================
#'
  x<-0.2
 Phi(x)==stats::pnorm(x)



#========================================================================================
#            1)             Build the data
#========================================================================================
#'

 a  <-  0.1;
 NX <-  222;
 x  <-  runif(100,-11,11)
 y  <-  Phi_inv(exp(a/NX) *Phi(x))-x
 plot(x,y)

 a  <-  0.1;
 NX <-  222;
 x  <-  runif(100,0,11)
 y  <-  Phi_inv(exp(a/NX) *Phi(x))-x
 plot(x,y)


 a  <-  0.1;
 NX <-  222;
 x  <-  runif(100,2,4)
 y  <-  Phi_inv(exp(a/NX) *Phi(x))-x
 plot(x,y)

 a  <-  0.01;
 NX <-  222;
 x  <-  runif(100,2,4);
 y  <-  Phi_inv(exp(a/NX) *Phi(x))-x
 plot(x,y)




 a  <-  0.01;
 NX <-  222;
 x  <-  runif(100,3.5,4);
 y  <-  Phi_inv(exp(a/NX) *Phi(x))-x
 plot(x,y)


}
\seealso{
\code{\link{Phi_inv}()}
}
