% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_dataset_MRMC.R
\docType{data}
\name{ddd}
\alias{ddd}
\title{Multiple reader and Multiple modality data}
\description{
This is a subset of \code{ \link{dd}}

This dataset has different dimesion for each moality and reader and confidence levels.
To confirm my program is correct, the author made this.

In  the following I emphasis that this data set has different dimensions:
\strong{  Different numbers   } \emph{ Different numbers     } \strong{  Different numbers   } \emph{ Different numbers     } \strong{  Different numbers   } \emph{ Different numbers     }
\strong{  Different numbers   } \emph{ Different numbers     } \strong{  Different numbers   } \emph{ Different numbers     } \strong{  Different numbers   } \emph{ Different numbers     }
\describe{
\item{ ddd$C   }{ 5 Confidence levels }
\item{ ddd$M   }{ 3 modalities   }
\item{ ddd$Q   }{ 4 readers}
}

\strong{  Different numbers   } \emph{ Different numbers     } \strong{  Different numbers   } \emph{ Different numbers     } \strong{  Different numbers   } \emph{ Different numbers     }
\strong{  Different numbers   } \emph{ Different numbers     } \strong{  Different numbers   } \emph{ Different numbers     } \strong{  Different numbers   } \emph{ Different numbers     }

So, all number, i.e. \code{M,C,Q} is \emph{different} each other and this is the reason why the author made this dataset.
}
\details{
The WAIC is finite which surprizes me,
because a dataset  \code{dd} has no finite WAIC. Why??

I forgot when I wrote this and what model was fitted to this data, so
I am not sure the current model has finite WAIC.

Revised 2019 Nov. 21

\strong{Contents of dd}


 \code{NL}  = 142 (Number of Lesions)

 \code{NI} = 199 (Number of Images)








---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ModalityID } \tab   \strong{ReaderID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{m} \tab  \code{ q}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
    -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
1 \tab 1 \tab 5 \tab  0 \tab 50\cr
1 \tab 1 \tab 4 \tab  4 \tab 30\cr
1 \tab 1 \tab 3 \tab 20 \tab 11\cr
1 \tab 1 \tab 2 \tab 29 \tab  5\cr
1 \tab 1 \tab 1 \tab 21 \tab  1\cr
1 \tab 2 \tab 5 \tab  0 \tab 15\cr
1 \tab 2 \tab 4 \tab  0 \tab 29\cr
1 \tab 2 \tab 3 \tab  6 \tab 29\cr
1 \tab 2 \tab 2 \tab 15 \tab  1\cr
1 \tab 2 \tab 1 \tab 22 \tab  0\cr
1 \tab 3 \tab 5 \tab  1 \tab 39\cr
1 \tab 3 \tab 4 \tab 15 \tab 31\cr
1 \tab 3 \tab 3 \tab 18 \tab  8\cr
1 \tab 3 \tab 2 \tab 31 \tab 10\cr
1 \tab 3 \tab 1 \tab 19 \tab  3\cr
1 \tab 4 \tab 5 \tab  1 \tab 10\cr
1 \tab 4 \tab 4 \tab  2 \tab  8\cr
1 \tab 4 \tab 3 \tab  4 \tab 25\cr
1 \tab 4 \tab 2 \tab 16 \tab 45\cr
1 \tab 4 \tab 1 \tab 17 \tab 14\cr
2 \tab 1 \tab 5 \tab  1 \tab 52\cr
2 \tab 1 \tab 4 \tab  1 \tab 25\cr
2 \tab 1 \tab 3 \tab 21 \tab 13\cr
2 \tab 1 \tab 2 \tab 24 \tab  4\cr
2 \tab 1 \tab 1 \tab 23 \tab  1\cr
2 \tab 2 \tab 5 \tab  1 \tab 27\cr
2 \tab 2 \tab 4 \tab  1 \tab 28\cr
2 \tab 2 \tab 3 \tab  5 \tab 29\cr
2 \tab 2 \tab 2 \tab 30 \tab  1\cr
2 \tab 2 \tab 1 \tab 40 \tab  0\cr
2 \tab 3 \tab 5 \tab  2 \tab 53\cr
2 \tab 3 \tab 4 \tab 19 \tab 29\cr
2 \tab 3 \tab 3 \tab 31 \tab 13\cr
2 \tab 3 \tab 2 \tab 56 \tab  2\cr
2 \tab 3 \tab 1 \tab 42 \tab  4\cr
2 \tab 4 \tab 5 \tab  2 \tab  9\cr
2 \tab 4 \tab 4 \tab  0 \tab 16\cr
2 \tab 4 \tab 3 \tab  2 \tab 22\cr
2 \tab 4 \tab 2 \tab 30 \tab 43\cr
2 \tab 4 \tab 1 \tab 32 \tab 14\cr
3 \tab 1 \tab 5 \tab  1 \tab 43\cr
3 \tab 1 \tab 4 \tab  7 \tab 29\cr
3 \tab 1 \tab 3 \tab 13 \tab 11\cr
3 \tab 1 \tab 2 \tab 28 \tab  6\cr
3 \tab 1 \tab 1 \tab 19 \tab  0\cr
3 \tab 2 \tab 5 \tab  0 \tab 18\cr
3 \tab 2 \tab 4 \tab  1 \tab 29\cr
3 \tab 2 \tab 3 \tab  7 \tab 21\cr
3 \tab 2 \tab 2 \tab  7 \tab  0\cr
3 \tab 2 \tab 1 \tab 31 \tab  0\cr
3 \tab 3 \tab 5 \tab  7 \tab 43\cr
3 \tab 3 \tab 4 \tab 15 \tab 29\cr
3 \tab 3 \tab 3 \tab 28 \tab  6\cr
3 \tab 3 \tab 2 \tab 41 \tab  7\cr
3 \tab 3 \tab 1 \tab  9 \tab  1\cr
3 \tab 4 \tab 5 \tab  0 \tab 10\cr
3 \tab 4 \tab 4 \tab  2 \tab 14\cr
3 \tab 4 \tab 3 \tab  5 \tab 19\cr
3 \tab 4 \tab 2 \tab 24 \tab 32\cr
3 \tab 4 \tab 1 \tab 31 \tab 23
}
---------------------------------------------------------------------------------------------------
}
\examples{
####1#### ####2#### ####3#### ####4#### ####5#### ####6#### ####7#### ####8#### ####9####
#----------------------------------------------------------------------------------------
#              make an object ddd from an object dd
#----------------------------------------------------------------------------------------



           ddd  <-  data.frame(m=dd$m,q=dd$q,c=dd$c,h=dd$h,f=dd$f)

           dddd <-  ddd[ddd$m <4,]  #  Reduce the dataset ddd, i.e., dd

ddd <- list(
           m=dddd$m,
           q=dddd$q,
           c=dddd$c,
           h=dddd$h,
           f=dddd$f,
           NL=142,
           C=max(dddd$c),
           M=max(dddd$m),
           Q=max(dddd$q)
        )

#----------------------------------------------------------------------------------------
#           the following gives convergence seed 2019 Oct 12
#----------------------------------------------------------------------------------------
\donttest{
f <- fit_Bayesian_FROC( ite  = 1111, cha = 1, summary = T, dataList = ddd ,see = 123456)
}




}
\references{
Nothing in 2018
}
\author{
Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
}
