# devtools::document();?BayesianFROC
#' @title FROC Analysis via Bayesian Approaches
#' @description
#'
#'
#' the following three Shiny based GUI would helps
#'
#' \describe{
#' \item{  \code{ \link{fit_GUI_Shiny}()}    }{Interactive GUI}
#' }
#'
#' by code \code{?BayesianFROC} or \code{help(BayesianFROC)}
#'
#'
#'
#'
#' @details
#'
#'
# ###### @keywords internal This cause heavy warning, never use.
#'
#' Statistical modeling is only calculations of probability of the event that data arises.
#' First, we explain what is data in the FROC context.
#' Second, we calcultes a probality with parameter.
#'
#'
#'  \emph{\strong{FROC trial and data}}
#'
#  There are \emph{ \eqn{R} readers, \eqn{N_I} images, a researcher}.
#' There are \strong{\emph{ a reader, \eqn{N_I} images, a researcher}}.
#'
#'
#' \describe{
#' \item{1}{The researcher gives the reader the \strong{\emph{first}} image.}
#' \item{2. \strong{\emph{LESION FINDING TASK}}  }{The reader marks their suspicious locations (muliple answer is allowed) with a \strong{\emph{integer}} indicating their \strong{\emph{confidence}} levels (if he or she thinks it is obviously lesion, then he or she gives higher integer)}
#' \item{3}{The researcher gives the reader the second image and reader do the above LESION FINDING TASK for the second image.}
#' \item{4}{The reader do the \strong{\emph{LESION FINDING TASK}}   for all images}
#' \item{5}{The researcher count the number of their true marking positions (\emph{hit}) and false making positions (\emph{false alarm}).}
#' }
#'
#' Consequently, we obtain the following table.
#'
#'
#'
#'\strong{\emph{ Example data and its Format:}}
#'
#'  \emph{            A single reader and a single modality case   }
#'---------------------------------------------------------------------------------------------------
#' \tabular{rccc}{
#' \code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
#'  In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
#'   -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
#' \emph{definitely} present  \tab  \code{c[1] = }5 \tab \code{f[1] = }\eqn{F_5} = 1 \tab  \code{h[1] = }\eqn{H_5} = 41 \cr
#'  \emph{probably} present   \tab  \code{c[2] = }4 \tab \code{f[2] = }\eqn{F_4} = 2 \tab  \code{h[2] = }\eqn{H_4} = 22 \cr
#'  equivocal                 \tab  \code{c[3] = }3 \tab \code{f[3] = }\eqn{F_3} = 5 \tab  \code{h[3] = }\eqn{H_3} = 14  \cr
#'  subtle                    \tab  \code{c[4] = }2 \tab \code{f[4] = }\eqn{F_2} = 11 \tab \code{h[4] = }\eqn{H_2} = 8  \cr
#'  \emph{very} subtle        \tab  \code{c[5] = }1 \tab \code{f[5] = }\eqn{F_1} = 13 \tab \code{h[5] = }\eqn{H_1} = 1  \cr
#'  }
#'---------------------------------------------------------------------------------------------------

#'
#'
#'  By the R code \code{BayesianFROC::viewdata(BayesianFROC::dataList.Chakra.1.with.explantation)}, we can see example data named \code{"dataList.Chakra.1.with.explantation"}.
#'
#'
#'
#'
#'
#'
#'  \emph{\strong{Modeling}}
#'
#' Modeling is a calculation of the event that each dataset arises.
#'
#' First, we shall discuss our model rigorously.
#' Suppose that there are \eqn{N_L} targets (signal), and radiological context, target is lesion.
#' Suppoes that a radiologist try to find lesions from radiographs.
#' Suppose that now, the reader fined \eqn{H} lesions
#' from radiographs which contains \eqn{N_L} lesions,
#' then it is natrual to assume that
#'
#'  \deqn{ H ~ Binomial(\theta, N_L)}
#'
#' where, \eqn{\theta} is a parameter of model, which should be estimated.
#'
#' In addition, suppose that the reader fails \eqn{F} times, that is,
#' reader marked \eqn{F} false positives. Then it natrual to assume that
#'
#'
#'  \deqn{ F ~ Poisson(\lambda)}
#'
#'
#' where, \eqn{\lambda} is a parameter of model, which should be estimated.
#'
#'
#'  The above two is very simple, since data is only \eqn{H,F},
#'  indicating the number of TP and the number of FP.
#'
#'  \strong{\emph{Unfortunatley}}, the FROC data is more complex than above.
#'  That is, reader answers with his confidence levels, which is usually number of 1,2,3,4,5:
#'
#'
#'
#'
#'
#'
#'
#' \describe{
#' \item{ \code{ \link{fit_GUI_Shiny}()  }      }{  GUI of Shiny }
#' \item{ \code{ \link{fit_Bayesian_FROC}}    }{ CUI           }
#' }
#'
#'
#'
#' Modeling is a calculation of the event that each dataset arises.
#'
#' Suppose that there are \eqn{N_L} targets,
#' and radiological context, target is lesion.
#' Suppoes that a radiologist try to find lesions.
#' Suppose that now, the reader fined \eqn{H_c} lesions
#' with his \eqn{c}-th confidence,
#' then it is natrual to assume that
#'
#'  \deqn{ H_5 ~ Binomial(p_5(\theta), N_L)}
#'  \deqn{ H_4 ~ Binomial(\frac{p_4(\theta)}{1-p_5(\theta) }, N_L - H_5)}
#'  \deqn{ H_3 ~ Binomial(\frac{p_3(\theta)}{1-p_5(\theta)-p_4(\theta) }, N_L - H_5 - H_4)}
#'  \deqn{ H_2 ~ Binomial(\frac{p_2(\theta)}{1-p_5(\theta)-p_4(\theta)-p_3(\theta)  }, N_L - H_5 - H_4 -H_3)}
#'  \deqn{ H_1 ~ Binomial(\frac{p_1(\theta)}{1-p_5(\theta)-p_4(\theta)-p_3(\theta)-p_2(\theta)  }, N_L - H_5 - H_4 -H_3 -H_2)}
#'
#'  where, hit rates \eqn{p_1(\theta)},
#'                   \eqn{p_2(\theta)},
#'                   \eqn{p_3(\theta)},
#'                   \eqn{p_4(\theta)} and
#'                   \eqn{p_5(\theta)} are
#'                    functions of
#'                    a model parameter \eqn{\theta},
#'                     which should be estimated.
#' In addition,
#'  suppose that the reader fails \eqn{F_c} times
#'   with his \eqn{c}-th confidence,
#'   that is,
#' reader marked \eqn{F_c} false positives.
#'  Then it natrual to assume that
#'
#'
#'  \deqn{ F_5 ~ Poisson(q_5(\theta))}
#'  \deqn{ F_4 ~ Poisson(q_4(\theta))}
#'  \deqn{ F_3 ~ Poisson(q_3(\theta))}
#'  \deqn{ F_2 ~ Poisson(q_2(\theta))}
#'  \deqn{ F_1 ~ Poisson(q_1(\theta))}

#'
#' where,  false rate
#' \eqn{q_1(\theta)},
#' \eqn{q_2(\theta)},
#' \eqn{q_3(\theta)},
#' \eqn{q_4(\theta)} and
#' \eqn{q_5(\theta)} are
#' functions  of  a parameter of model,
#'  which should be estimated.
#'
#'
#'  The above two is very simple, since data is only \eqn{H,F},
#'  indicating the number of TP and the number of FP.
#'
#'
#'
#' We use Gaussian distributions for
#'  such functions \eqn{p_c(\theta)}
#'  and \eqn{q_c(\theta)}.
#'
#'
#' \deqn{p_c(\theta)= \int ^{\theta_{c+1}}_{\theta_c} Gaussian(z|\mu, \sigma) dz        }
#'
#'
#' \deqn{q_c(\theta)= \int ^{\theta_{c+1}}_{\theta_c} N_I frac{d}{dz} \Phi(z) dz        }
#'
#'
#' where the model parameter vector which should be estimated is
#'
#'  \deqn{ \theta = (\theta_1,\theta_2,...,\theta_C; \mu,\sigma).}
#'
#'
#'
#'
#'Intuitively, the reason why we choose such function
#'forms for \eqn{p_c(\theta)} is the assumption that
#'each lesion is equipped with i.i.d. latent variable,
#' \eqn{X} distributed by \eqn{ Gaussian(z|\mu, \sigma) }, and
#'if the \eqn{X} associated to some lesion falls
#'into interval the interval \eqn{ \theta_c <X< \theta_{c+1}},
#'then we consider that
#'the reader will hit with his \eqn{c}-th confidence level for the lesion.
#' In oreder to emphasize that each \eqn{X} is
#' associated to some  \eqn{l}-th lesion,
#'  \eqn{l=1,2,...,N_L} we denote the latent variable \eqn{X_l} for \eqn{l}-th lesion insead the latent decision variable \eqn{X}.
#'
#'
#'Here, we uses \emph{latent} to means that the variable \eqn{X} cannot observed. Since the latent variable relates decision of reader, and thus, in this context
#'the latent variable is called a \emph{decision} variable.
#'
#'Similarily, suppose that each image (radiograph) is associated some latent variable \eqn{Y}
#' distibuted by \eqn{ N_I frac{d}{dz} \Phi(z)} and if the \eqn{Y} associated to some image falls into interval the interval \eqn{ \theta_c <Y<\theta_{c+1}}, then we consider that
#'the reader will false decision with his \eqn{c}-th confidence level for the image.
#'
#' To fit a model to any dataset, we use the code:
#'
#' \describe{
#' \item{  \code{ \link{fit_Bayesian_FROC}()}   }{ Fit a model to data                  }
#' \item{  \code{ \link{dataList.Chakra.2}}     }{Example data in Chakraborty 1989 paper}
#' \item{  \code{ \link{dataList.Chakra.3}}     }{Example data in Chakraborty 1989 paper}
#' \item{  \code{ \link{dataList.Chakra.4}}     }{Example data in Chakraborty 1989 paper}
#' }
#'
#'
#'
#'
#'
#'
#'
#'  \emph{\strong{Visualization of our data}}
#'
#'  We shall consider how to visualize our data constructed by hit and false alarms, that is, TP and FP.
#'  The traditionaly, the so-called FPF;False Positive Fraction and TPT:True Positive Fraction are used.
#'  Recall that our data format:
#'
#'
#'
#'
#'  \emph{            A single reader and a single modality case   }
#'
#'------------------------------------------------------------------------------------------------------

#' \tabular{rccc}{
#' \code{NI, NL }   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
#'            \tab    \tab   (FP:False Positive)  \tab    (TP:True Positive) \cr
#'     -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
#' \emph{definitely} present  \tab   5 \tab  \eqn{F_5}   \tab   \eqn{H_5}  \cr
#'  \emph{probably} present   \tab   4 \tab  \eqn{F_4}  \tab   \eqn{H_4}   \cr
#'  equivocal                 \tab   3 \tab  \eqn{F_3}  \tab   \eqn{H_3}    \cr
#'  subtle                    \tab   2 \tab  \eqn{F_2}  \tab  \eqn{H_2}    \cr
#'  \emph{very} subtle        \tab   1 \tab  \eqn{F_1}  \tab \eqn{H_1}    \cr
#'  }
#'
#'---------------------------------------------------------------------------------------------------
#'
#' FPF is defined as follows;
#'
#'
#' \deqn{FPF(5):= frac{F_5}{NI},}
#' \deqn{FPF(4):= frac{F_4+F_5}{NI},}
#' \deqn{FPF(3):= frac{F_3+F_4+F_5}{NI},}
#' \deqn{FPF(2):= frac{F_2+F_3+F_4+F_5}{NI},}
#' \deqn{FPF(1):= frac{F_1+F_2+F_3+F_4+F_5}{NI}.}
#'
#'
#' TPF is defined as follows;
#'
#'
#' \deqn{TPF(5):= frac{H_5}{NL},}
#' \deqn{TPF(4):= frac{H_4+H_5}{NL},}
#' \deqn{TPF(3):= frac{H_3+H_4+H_5}{NL},}
#' \deqn{TPF(2):= frac{H_2+H_3+H_4+H_5}{NL},}
#' \deqn{TPF(1):= frac{H_1+H_2+H_3+H_4+H_5}{NL}.}
#'
#'
#'
#' Altogether and plotting in a plain the following points, we obtain the visualization of our data.
#'
#'  \deqn{(   FPF(1), TPF(1)   ),}
#'  \deqn{(   FPF(2), TPF(2)   ),}
#'  \deqn{(   FPF(3), TPF(3)   ),}
#'  \deqn{(   FPF(4), TPF(4)   ),}
#'  \deqn{(   FPF(5), TPF(5)   ).}
#'
#'
#' So, there will be 5 points in a plain.
#'
#' In addition, if we connect these points by lines, we obtain the so-called \emph{empirical FROC curve.}
#'
#'
# ####1#### ####2#### ####3#### ####4#### ####5#### ####6#### ####7#### ####8#### ####9####
#'  \emph{\strong{Visualization of our model}}
#'  In this section, we provides the so-called \emph{FROC curve} which is our desired
#'  visualization of estimated model.
#'  Roughly speaking, \strong{an FROC curve is expected pairs of FPF and TPF.}
#'  Namely, the points of FPF and TPF will be on FROC curve if model is  well fitting to data.
#'  So, comparing the FROC curve and the FPF and TPF, we can evaluate our goodness of fit.
#'
#'
#'  In the above, ha,... I want to die.
#'
#'
#'
#'  Let \eqn{c = 1,2,3,4,5}.
#'
#'  Define
#'
#'   \deqn{x(c):= E[ FPF(c) ], }
#'
#'   \deqn{y(c):= E[  TPF(c) ]. }
#'
#'
#'
#'
#' Then,
#'
#'
#'
#'   \deqn{x(c):= E[ FPF(c) ] =\int^\infty_{\theta_c}frac{d}{dz} \Phi(z) = - log \Phi(\theta_c),}
#'
#'   \deqn{y(c):= E[  TPF(c) ] =\int^\infty_{\theta_c} Gaussian(z|\mu, \sigma) dz = \Phi(\frac{\theta_c - \mu}{\sigma}).}
#'
#'
#' From the first equation, we obtain
#' that \eqn{ \theta_c = \Phi^{-1}(exp(-x(c)))}.
#' Substituting this into the second equation, we obtain that
#'
#'
#'   \deqn{y(c) = \Phi(\frac{ \Phi^{-1}(exp(-x(c))) - \mu}{\sigma}).}
#'
#'
#' This implies that all expections for the pair of FPF and TPF is on the set:
#'
#'
#'   \deqn{  \{(x,y) |     y= \Phi(\frac{ \Phi^{-1}(exp(-x) - \mu}{\sigma})\}.  }
#'
#'
#' We can regrad this set as an image of smooth curves, Namely,
#' here we define the so-called FROC curve as a map from 1-dimensional Euclidean space to
#' 2-dimensional Euclidean space, mapping each \eqn{t>0} to
#'
#' \deqn{  (x(t),y(t) ) =(t, \Phi(\frac{ \Phi^{-1}(exp(-t) - \mu}{\sigma})   ) )}
#'
#'
#' Sine \eqn{x(t)=t,t>0} is not bounded, the area under the FROC curve is infinity.
#'
#' To calculates aleternative notion of AUC in the ordinal ROC theory, we define the so-called
#' AFROC curve:
#'
#' \deqn{  (\xi(t),\eta(t) ) =(1-e^{-t}, \Phi(\frac{ \Phi^{-1}(exp(-t) - \mu}{\sigma})   ) )}
#'
#'
#' which contained in the rectangular space \eqn{[0,1]^2}.

#' whose Area Under the Curve (AUC) represents the observer performance, namely, if a radiologist
#' if radiologist detects more lesions with small False Positives (FPs), then AUC is high.
#'
#'
#'
#'
#'
#'  \emph{\strong{Hierarchical Model for Multiple Readers and Mutiple Modalities (MRMC)}}
#'
#'  See \code{\link{fit_Bayesian_FROC}()}.

#'  Therory is trivial and omitted,
#'
#'  Example dataset is  \code{\link{dd}} and \code{\link{ddd}} and \code{\link{dddd}} and \code{\link{ddddd}} and ...etc.

#'
#'  \emph{\strong{Validation of model via SBC          }}
#'
#' \strong{Talts, S., Betancourt, M., Simpson, D., Vehtari, A., and Gelman, A. (2018). Validating Bayesian Inference Algorithms with Simulation-Based Calibration. arXiv preprint arXiv:1804.06788. https://arxiv.org/abs/1804.06788}
#'
#'
#'  \emph{\strong{Validation of model  via  Posterior Predictive p value        }}
#'
#'  See \code{\link{ppp}()}.
#'
#'
#'
#' Let \eqn{ \theta_1,\theta_2,...,\theta_n} be a sample from a posterior \eqn{\pi(.| D)} for a given dataset \eqn{D}.
#' Let \eqn{ y^i_j ~ likelihood(| \theta_i)}.
#'
#' For any \eqn{\phi},
#'
#' \deqn{ \int \int \phi(y,\theta) likelihood(y| \theta) \pi(\theta|y)dy d\theta}
#' \deqn{ =\int \Sigma \phi(y,\theta_i) likelihood(y| \theta_i) dy }
#' \deqn{ =\Sigma \Sigma \phi( y^i_j,\theta_i) likelihood( y^i_j| \theta_i).  }
#'  Using this  \eqn{\phi= 1(T(y,\theta)> T(y,\theta_{observed}))}, we obtain the so-called
#'  \emph{posterior predicitive p value.} (The author hatest this notion.)

#'
#'  In my opinion, this criteria is not clear whether it is reliable quantities for evaluations.
#'
#'
#'  \emph{\strong{Validation of model  via  fitting models to replicated datasets drawn from know distribution       }}
#'
#'
#'  I think this is the most fundamental and intuitive validation.
#'
#'  \emph{\strong{Appendix:  -----      Terminology    -------}}
#'
#'\describe{
#' \item{  \emph{hit }                }{ Also called True Positive: TP, which is denoted with each confidence level, \eqn{c=1,2,3,...,C} as follows: \eqn{H_1,H,2,...,H_C} or \code{h=c(h[1],h[2],...,h[C])},   where \code{h[1]}=\eqn{H_C} corresponds a number of hit with most high confidence level}
#' \item{  \emph{False alarm  }       }{ Also called False Positive: FP , which is denoted with each confidence, \eqn{c=1,2,3,...,C} levels as follows: \eqn{F_1,F,2,...,F_C} or \code{f=c(f[1],f[2],...,f[C])}, where \code{f[1]}=\eqn{F_C} corresponds a number of false alarms witf most high confidence level}
#' \item{  \emph{Modality }           }{ Imaging methods, such as MRI, CT, PET,...etc}
#' \item{  \emph{Modality comparison} }{ The question that which modality (MRI, CT, PET, ... etc) is best to detect lesions in radiographs? In order to answer this question, the FROC analysis exists.}
#' \item{  \emph{hit  rate}           }{ Each lesion generate a hit of confidence level \eqn{c} according to Bernoulli distribution with probaility of \eqn{p_c}, which call hit rate (of \eqn{c})}
#' \item{  \emph{false alarm  rate}   }{ Each image generate a false alarm (False Positive: FP) of confidence level \eqn{c} according to Poisson distribution with probaility of \eqn{lambda_c}, which call \emph{false alarm rate (of \eqn{c})} or \emph{simply false} rate.}
#' \item{  \emph{Number of images}    }{ which is denoted by  \eqn{N_I}. image means radiographs, including lesions or noise. Namely, each radiograph does not necessarily includes lesions. }
#' \item{  \emph{Number of Lesions}   }{ Suppose there are \eqn{N_I} radiographs, including lesions then }
#' \item{  \emph{FROC curve}          }{ alternative notion of ROC curve in FROC context. }
#' \item{  \emph{AFROC curve}         }{ Alternative-FROC curve, whose area under the curve is used for evaluation of observer performance. Since area under the FROC curve is infinity, we use this are under the AFROC curve instead of the are under the FROC curve.}
#' \item{  \emph{AUC}                            }{ A real number between 0 and 1, indicating A metic to evaluate how much radiologist can detect lesions from radiographs. Area under the AFROC curve. In ROC context, AUC might be greater than 0.5,  but in  FROC context, the interpreation of AUC is not same as ROC context. For example, AUC =0.5 does not means that it is sames as the most bad observer perfomance.}
#' \item{  \emph{Chi square}                     }{ Defined by the difference of expected values from estimates minus actual observered data. Smaller is better.}
#' \item{  \emph{Posterior Predictive P value }  }{  For details, see Gelman's book. The author implements this for the \eqn{\chi^2} goodness of fit. The author hates this traditional bitch. }
#' \item{  \emph{FPF:False Positive Fraction }   }{  Cumulative sum of false alarms (FPs) per Image}
#' \item{  \emph{TPF:True Positive Fraction }    }{  Cumulative sum of hits (TPs) per Lesion (signal, target)}
#' }
#'
#'
#'
#' @name BayesianFROC
#' @docType package
NULL
