% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicate_MRMC_data.R
\name{false_and_its_rate_creator_MRMC}
\alias{false_and_its_rate_creator_MRMC}
\title{MRMC: False Alarm Creator For each Modality and each Reader.}
\usage{
false_and_its_rate_creator_MRMC(z.truth = BayesianFROC::z_truth,
  NI = 333, NL = 111, ModifiedPoisson = FALSE, seed = 12345,
  M = 5, Q = 4, summary = TRUE)
}
\arguments{
\item{z.truth}{Vector of dimension = C represents the thresholds of bi-normal assumption.}

\item{NI}{The number of images.}

\item{NL}{The number of lesions.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm is \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE}, then False Positive Fraction (FPF) is calculated as follows
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE}(Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it use only per trial. But, if we devide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author developed FROC theory to consider FROC analysis under per signal.


Revised 2019 6.19}

\item{seed}{The seed for creating false alarm which are generated by the Poisson  distributions using the specified seed.}

\item{M}{Number of modalities}

\item{Q}{Number of readers}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\value{
Vector for false alarms as an element of list of MRMC data.
}
\description{
From threshold, mean and S.D., data of False Alarm are created.#'@details
In our hierarchical model, false alarm rate does not depend on the readers or modalities. Thus this sampling function merely draws samples from the Poisson distribution of the same false alarm rate. Of course, this same false rate of the Poisson distributions is not desired one. Since we should assume that each reader with different modality should differ. To accomplish this, we have to assume that threshold parameter of Gaussian assumption should depend on the reader and modality. But such model does not converge in the Hamiltonian Monte Carlo simulation.
}
\examples{
\donttest{
  false_and_its_rate_creator_MRMC()


}
}
